/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.common.util.StringUtils;
import io.vertx.core.http.HttpServerRequest;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public final class NetUtils {
    public static String getClientIPAddress(HttpServerRequest request) {
        String xRealIPStr = request.getHeader("X-Real-IP");
        String xForwardedForStr = request.getHeader("X-Forwarded-For");
        String remoteAddressStr = request.remoteAddress().hostAddress();
        String xRealIP = "";
        String[] xForwardedFor = new String[]{};
        String remoteAddress = "";
        if (StringUtils.notBlank(xRealIPStr) && !"unknown".equalsIgnoreCase(xRealIPStr)) {
            xRealIP = xRealIPStr;
        }
        if (StringUtils.notBlank(xForwardedForStr) && !"unknown".equalsIgnoreCase(xForwardedForStr)) {
            xForwardedFor = xForwardedForStr.split(",");
        }
        remoteAddress = "0:0:0:0:0:0:0:1".equals(remoteAddressStr) ? "127.0.0.1" : remoteAddressStr;
        if (StringUtils.notBlank(xRealIP)) {
            return xRealIP;
        }
        if (xForwardedFor.length > 0) {
            return xForwardedFor[0];
        }
        return remoteAddress;
    }

    public static IPAddress getLocalIPAddress() {
        try {
            List<InetAddress> allAddresses = Stream.concat(NetworkInterface.networkInterfaces().flatMap(NetworkInterface::inetAddresses), Stream.of(InetAddress.getLocalHost())).filter(c -> !c.isLoopbackAddress()).toList();
            String[] ipv4AddressList = (String[])allAddresses.stream().filter(c -> c instanceof Inet4Address).map(InetAddress::getHostAddress).distinct().toArray(String[]::new);
            String[] ipv6AddressList = (String[])allAddresses.stream().filter(c -> c instanceof Inet6Address).map(InetAddress::getHostAddress).distinct().toArray(String[]::new);
            return new IPAddress(ipv4AddressList, ipv6AddressList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new IPAddress(new String[0], new String[0]);
        }
    }

    public record IPAddress(String[] v4, String[] v6) {
        public String[] getNormalIP() {
            return this.v4.length > 0 ? this.v4 : this.v6;
        }

        public String v4ToString() {
            return "[" + String.join((CharSequence)", ", this.v4) + "]";
        }

        public String v6ToString() {
            return "[" + String.join((CharSequence)", ", this.v6) + "]";
        }

        @Override
        public String toString() {
            ArrayList l = new ArrayList();
            Collections.addAll(l, this.v4);
            Collections.addAll(l, this.v6);
            return "[" + String.join((CharSequence)", ", l) + "]";
        }
    }
}

