/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.ansi;

import cool.scx.common.util.ansi.Ansi8BitBackground;
import cool.scx.common.util.ansi.Ansi8BitColor;
import cool.scx.common.util.ansi.AnsiBackground;
import cool.scx.common.util.ansi.AnsiColor;
import cool.scx.common.util.ansi.AnsiElement;
import cool.scx.common.util.ansi.AnsiHelper;
import cool.scx.common.util.ansi.AnsiStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public final class Ansi {
    private static final String ENCODE_JOIN = ";";
    private static final String ENCODE_START = "\u001b[";
    private static final String ENCODE_END = "m";
    private static final String RESET = "0;" + AnsiColor.DEFAULT.code();
    private static final boolean enabled = AnsiHelper.detectIfAnsiCapable();
    private static final Iterator<AnsiColor> CYCLE_COLOR = AnsiHelper.initCycleColor();
    private final List<Object> elements = new ArrayList<Object>();

    private Ansi() {
    }

    public static Ansi out() {
        return new Ansi();
    }

    public static String encode(AnsiElement element) {
        if (enabled) {
            return ENCODE_START + String.valueOf(element) + ENCODE_END;
        }
        return "";
    }

    private static void buildEnabled(StringBuilder sb, List<Object> elements) {
        boolean writingAnsi = false;
        boolean containsEncoding = false;
        for (Object element : elements) {
            if (element instanceof AnsiElement) {
                containsEncoding = true;
                if (!writingAnsi) {
                    sb.append(ENCODE_START);
                    writingAnsi = true;
                } else {
                    sb.append(ENCODE_JOIN);
                }
                sb.append(((AnsiElement)element).code());
                continue;
            }
            if (writingAnsi) {
                sb.append(ENCODE_END);
                writingAnsi = false;
            }
            sb.append(element);
        }
        if (containsEncoding) {
            sb.append(writingAnsi ? ENCODE_JOIN : ENCODE_START);
            sb.append(RESET);
            sb.append(ENCODE_END);
        }
    }

    private static void buildDisabled(StringBuilder sb, List<Object> elements) {
        for (Object element : elements) {
            if (element instanceof AnsiElement || element == null) continue;
            sb.append(element);
        }
    }

    private static AnsiElement[] filterAnsiElement(AnsiElement[] elements, AnsiElement ... elements2) {
        AnsiElement ansiColor = null;
        AnsiElement ansiBackground = null;
        LinkedHashSet<AnsiStyle> ansiStyleSet = new LinkedHashSet<AnsiStyle>();
        AnsiElement[] ansiElements = new AnsiElement[elements.length + elements2.length];
        System.arraycopy(elements, 0, ansiElements, 0, elements.length);
        System.arraycopy(elements2, 0, ansiElements, elements.length, elements2.length);
        for (AnsiElement element : ansiElements) {
            if (element instanceof AnsiColor || element instanceof Ansi8BitColor) {
                ansiColor = element;
                continue;
            }
            if (element instanceof AnsiBackground || element instanceof Ansi8BitBackground) {
                ansiBackground = element;
                continue;
            }
            if (!(element instanceof AnsiStyle)) continue;
            ansiStyleSet.add((AnsiStyle)element);
        }
        ArrayList<AnsiElement> l = new ArrayList<AnsiElement>();
        if (ansiColor != null) {
            l.add(ansiColor);
        }
        if (ansiBackground != null) {
            l.add(ansiBackground);
        }
        l.addAll(ansiStyleSet);
        return (AnsiElement[])l.toArray(AnsiElement[]::new);
    }

    public Ansi red(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.RED));
    }

    public Ansi green(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.GREEN));
    }

    public Ansi brightCyan(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BRIGHT_CYAN));
    }

    public Ansi blue(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BLUE));
    }

    public Ansi cyan(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.CYAN));
    }

    public Ansi brightBlue(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BRIGHT_BLUE));
    }

    public Ansi brightMagenta(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BRIGHT_MAGENTA));
    }

    public Ansi brightRed(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BRIGHT_RED));
    }

    public Ansi brightGreen(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BRIGHT_GREEN));
    }

    public Ansi black(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BLACK));
    }

    public Ansi brightBlack(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BRIGHT_BLACK));
    }

    public Ansi brightYellow(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BRIGHT_YELLOW));
    }

    public Ansi yellow(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.YELLOW));
    }

    public Ansi magenta(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.MAGENTA));
    }

    public Ansi white(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.WHITE));
    }

    public Ansi brightWhite(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.BRIGHT_WHITE));
    }

    public Ansi defaultColor(Object o, AnsiElement ... ansiElements) {
        return this.add(o, Ansi.filterAnsiElement(ansiElements, AnsiColor.DEFAULT));
    }

    public Ansi ln() {
        this.add(System.lineSeparator(), new AnsiElement[0]);
        return this;
    }

    public Ansi color(Object o, AnsiElement ... ansiElements) {
        this.add(o, Ansi.filterAnsiElement(ansiElements, CYCLE_COLOR.next()));
        return this;
    }

    public Ansi add(Object o, AnsiElement ... ansiElements) {
        this.elements.addAll(Arrays.asList(ansiElements));
        this.elements.add(o);
        return this;
    }

    public void print() {
        System.out.print(this);
    }

    public void print(boolean useAnsi) {
        System.out.print(this.toString(useAnsi));
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean useAnsi) {
        StringBuilder sb = new StringBuilder();
        if (enabled && useAnsi) {
            Ansi.buildEnabled(sb, this.elements);
        } else {
            Ansi.buildDisabled(sb, this.elements);
        }
        return sb.toString();
    }

    public void clear() {
        this.elements.clear();
    }

    public void println() {
        this.ln();
        this.print();
    }

    public void println(boolean useAnsi) {
        this.ln();
        this.print(useAnsi);
    }
}

