/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.io_stream_source;

import cool.scx.common.util.io_stream_source.BytesSource;
import cool.scx.common.util.io_stream_source.BytesSupplierSource;
import cool.scx.common.util.io_stream_source.NullSource;
import cool.scx.common.util.io_stream_source.OutputStreamSource;
import cool.scx.common.util.io_stream_source.PathSource;
import cool.scx.common.util.io_stream_source.RawInputStreamSource;
import cool.scx.common.util.io_stream_source.ZipEntrySource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public interface InputStreamSource
extends OutputStreamSource {
    public static InputStreamSource of() {
        return new NullSource();
    }

    public static InputStreamSource of(Path path) {
        return new PathSource(path);
    }

    public static InputStreamSource of(byte[] bytes) {
        return new BytesSource(bytes);
    }

    public static InputStreamSource of(Supplier<byte[]> bytesSupplier) {
        return new BytesSupplierSource(bytesSupplier);
    }

    public static InputStreamSource of(InputStream inputStream) {
        return new RawInputStreamSource(inputStream);
    }

    public static InputStreamSource of(ZipEntry zipEntry, ZipFile zipFile) {
        return new ZipEntrySource(zipEntry, zipFile);
    }

    public InputStream toInputStream() throws IOException;

    @Override
    default public byte[] toBytes() throws IOException {
        try (InputStream inputStream = this.toInputStream();){
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    @Override
    default public void writeToOutputStream(OutputStream out) throws IOException {
        try (InputStream inputStream = this.toInputStream();){
            inputStream.transferTo(out);
        }
    }

    default public String toString(Charset charset) throws IOException {
        return new String(this.toBytes(), charset);
    }
}

