/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.zip;

import cool.scx.common.util.io_stream_source.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;

public final class GunzipBuilder
implements InputStreamSource {
    private final InputStreamSource source;

    public GunzipBuilder(InputStreamSource source) {
        this.source = source;
    }

    public GunzipBuilder(Path path) {
        this(InputStreamSource.of(path));
    }

    public GunzipBuilder(byte[] bytes) {
        this(InputStreamSource.of(bytes));
    }

    public GunzipBuilder(Supplier<byte[]> bytesSupplier) {
        this(InputStreamSource.of(bytesSupplier));
    }

    public GunzipBuilder(InputStream inputStream) {
        this(InputStreamSource.of(inputStream));
    }

    @Override
    public InputStream toInputStream() throws IOException {
        return new GZIPInputStream(this.source.toInputStream());
    }
}

