package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;

import static cool.scx.common.util.ObjectUtils.constructType;
import static cool.scx.common.util.reflect.FieldUtils.findFieldInfos;
import static cool.scx.common.util.reflect.MethodUtils.findMethodInfos;

public final class ClassInfo {

    private final Class<?> _class;
    private final JavaType type;
    private final FieldInfo[] fields;
    private final MethodInfo[] methods;

    public ClassInfo(Class<?> _class) {
        this._class = _class;
        this.type = constructType(_class);
        this.fields = findFieldInfos(this.type);
        this.methods = findMethodInfos(this._class);
    }

    public Class<?> _class() {
        return this._class;
    }

    public JavaType type() {
        return type;
    }

    public FieldInfo[] fields() {
        return fields;
    }

    public MethodInfo[] methods() {
        return methods;
    }

}
