package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;

import java.lang.reflect.Field;
import java.util.ArrayList;

import static java.util.Collections.addAll;

public final class FieldUtils {

    public static Field[] findFields(Class<?> clazz) {
        var list = new ArrayList<Field>();
        while (clazz != null && !clazz.isInterface()) {
            var fields = clazz.getDeclaredFields();
            addAll(list, fields);
            clazz = clazz.getSuperclass();
        }
        return list.toArray(Field[]::new);
    }

    public static FieldInfo[] findFieldInfos(JavaType clazz) {
        //这里假定 一定是 class 
        var list = new ArrayList<FieldInfo>();
        while (clazz != null && !clazz.isInterface()) {
            var fields = clazz.getRawClass().getDeclaredFields();
            for (var field : fields) {
                list.add(new FieldInfo(field, clazz.getBindings()));
            }
            clazz = clazz.getSuperClass();
        }
        return list.toArray(FieldInfo[]::new);
    }

}
