package cool.scx.common.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import static cool.scx.common.util.reflect.MethodUtils.findAllAnnotations;

public class MethodInfo {

    private final Method _method;
    private final Annotation[] annotations;

    MethodInfo(Method _method) {
        this._method = _method;
        this.annotations = findAllAnnotations(this._method);
    }

    public Method _method() {
        return _method;
    }

    public Annotation[] annotations() {
        return annotations;
    }

}
