/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.zip;

import cool.scx.common.util.StringUtils;
import cool.scx.common.util.URIBuilder;
import cool.scx.common.util.zip.ZipBuilderItem;
import cool.scx.common.util.zip.ZipOptions;
import cool.scx.common.util.zip.zip_builder_item.PathZipBuilderItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipBuilder {
    private final List<ZipBuilderItem> items = new ArrayList<ZipBuilderItem>();

    public ZipBuilder() {
    }

    public ZipBuilder(ZipFile zipFile) {
        List<ZipBuilderItem> list = zipFile.stream().map(zipEntry -> new ZipBuilderItem((ZipEntry)zipEntry, zipFile)).toList();
        this.items.addAll(list);
    }

    public ZipBuilder(Path path) {
        this.put(path);
    }

    public ZipBuilder(Path path, ZipOptions zipOptions) {
        this.put(path, zipOptions);
    }

    public ZipBuilder put(String zipPath) {
        this.items.add(new ZipBuilderItem(zipPath));
        return this;
    }

    public ZipBuilder put(Path path, ZipOptions zipOptions) {
        this.items.add(new PathZipBuilderItem("", path, zipOptions));
        return this;
    }

    public ZipBuilder put(Path path) {
        return this.put(path, new ZipOptions());
    }

    public ZipBuilder put(String zipPath, Path path, ZipOptions zipOptions) {
        this.items.add(new PathZipBuilderItem(zipPath, path, zipOptions));
        return this;
    }

    public ZipBuilder put(String zipPath, byte[] bytes) {
        this.items.add(new ZipBuilderItem(zipPath, bytes));
        return this;
    }

    public ZipBuilder put(String zipPath, Supplier<byte[]> bytesSupplier) {
        this.items.add(new ZipBuilderItem(zipPath, bytesSupplier));
        return this;
    }

    public ZipBuilder put(String zipPath, InputStream inputStream) {
        this.items.add(new ZipBuilderItem(zipPath, inputStream));
        return this;
    }

    public ZipBuilder remove(String zipPath) {
        String p = URIBuilder.normalize(zipPath);
        if (StringUtils.notBlank(zipPath)) {
            this.items.removeIf(c -> c.zipPath.startsWith(p));
        }
        return this;
    }

    public ZipBuilderItem get(String zipPath) {
        String p = URIBuilder.normalize(zipPath);
        if (StringUtils.notBlank(zipPath)) {
            return this.items.stream().filter(c -> c.zipPath.startsWith(p)).findAny().orElse(null);
        }
        return null;
    }

    public List<ZipBuilderItem> items() {
        return this.items;
    }

    public void writeToZipOutputStream(ZipOutputStream zos) throws IOException {
        for (ZipBuilderItem i : this.items) {
            i.writeToZipOutputStream(zos);
        }
    }

    public byte[] toBytes(ZipOptions zipOptions) throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)bo, zipOptions.charset());){
            zos.setComment(zipOptions.comment());
            zos.setLevel(zipOptions.level());
            this.writeToZipOutputStream(zos);
        }
        return bo.toByteArray();
    }

    public byte[] toBytes() throws Exception {
        return this.toBytes(new ZipOptions());
    }

    public Path toFile(Path outputPath, ZipOptions zipOptions) throws IOException {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]), zipOptions.charset());){
            zos.setComment(zipOptions.comment());
            zos.setLevel(zipOptions.level());
            this.writeToZipOutputStream(zos);
        }
        return outputPath;
    }

    public Path toFile(Path outputPath) throws IOException {
        return this.toFile(outputPath, new ZipOptions());
    }
}

