package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

import static cool.scx.common.util.ObjectUtils.resolveMemberType;

public final class FieldInfo {

    private final Field _field;
    private final JavaType type;

    FieldInfo(Field _field, TypeBindings bindings) {
        this._field = _field;
        this.type = resolveMemberType(this._field.getGenericType(), bindings);
    }

    public Field _field() {
        return this._field;
    }

    public JavaType type() {
        return this.type;
    }

    public String name() {
        return this._field.getName();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._field.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this._field.getAnnotations();
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this._field.getAnnotationsByType(annotationClass);
    }

    public void setAccessible(boolean flag) {
        this._field.setAccessible(flag);
    }

    public void set(Object obj, Object value) throws IllegalAccessException {
        this._field.set(obj, value);
    }

    public Object get(Object obj) throws IllegalAccessException {
        return this._field.get(obj);
    }

}
