/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.http_client.body;

import cool.scx.common.http_client.ScxHttpClientRequestBody;
import cool.scx.common.http_client.body.form_data.FormDataHelper;
import cool.scx.common.http_client.body.form_data.FormDataItem;
import cool.scx.common.http_client.body.form_data.FormDataIterable;
import cool.scx.common.util.ScxExceptionHelper;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import java.net.http.HttpRequest;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class FormData
implements ScxHttpClientRequestBody {
    private final List<FormDataItem> items = new ArrayList<FormDataItem>();

    public FormData attribute(String name, Object text) {
        this.items.add(new FormDataItem(name, text.toString()));
        return this;
    }

    public FormData fileUpload(String name, byte[] fileByte) {
        this.items.add(new FormDataItem(name, fileByte));
        return this;
    }

    public FormData fileUpload(String name, byte[] fileByte, String filename) {
        this.items.add(new FormDataItem(name, fileByte, filename));
        return this;
    }

    public FormData fileUpload(String name, byte[] fileByte, String filename, String contentType) {
        this.items.add(new FormDataItem(name, fileByte, filename, contentType));
        return this;
    }

    public FormData fileUpload(String name, Path filePath) {
        this.items.add(new FormDataItem(name, filePath));
        return this;
    }

    public FormData fileUpload(String name, Path filePath, String filename) {
        this.items.add(new FormDataItem(name, filePath, filename));
        return this;
    }

    public FormData fileUpload(String name, Path filePath, String filename, String contentType) {
        this.items.add(new FormDataItem(name, filePath, filename, contentType));
        return this;
    }

    public FormData remove(String name) {
        this.items.removeIf(formDataItem -> name.equals(formDataItem.name()));
        return this;
    }

    public List<FormDataItem> items() {
        return this.items;
    }

    @Override
    public HttpRequest.BodyPublisher bodyPublisher(HttpRequest.Builder builder) {
        DefaultFullHttpRequest tempRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
        HttpPostRequestEncoder encoder = ScxExceptionHelper.wrap(() -> FormDataHelper.initEncoder(this, (HttpRequest)tempRequest));
        tempRequest.headers().forEach(k -> builder.header((String)k.getKey(), (String)k.getValue()));
        FormDataIterable formDataIterable = new FormDataIterable(encoder);
        return HttpRequest.BodyPublishers.ofByteArrays(formDataIterable);
    }
}

