/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.http_client.body.form_data;

import cool.scx.common.http_client.body.form_data.FormDataItemType;
import cool.scx.common.util.RandomUtils;
import cool.scx.common.util.StringUtils;
import io.vertx.core.http.impl.MimeMapping;
import java.nio.file.Path;
import java.util.Objects;

public final class FormDataItem {
    private final FormDataItemType type;
    private final String name;
    private final String filename;
    private final String contentType;
    private String attributeValue;
    private Path fileUploadPath;
    private byte[] fileUploadPathBytes;

    public FormDataItem(String name, String value) {
        this.type = FormDataItemType.ATTRIBUTE;
        this.name = Objects.requireNonNull(name);
        this.attributeValue = value;
        this.filename = null;
        this.contentType = null;
    }

    public FormDataItem(String name, byte[] content) {
        this(name, content, RandomUtils.randomUUID());
    }

    public FormDataItem(String name, byte[] content, String filename) {
        this(name, content, filename, MimeMapping.getMimeTypeForFilename((String)filename));
    }

    public FormDataItem(String name, byte[] content, String filename, String contentType) {
        this.type = FormDataItemType.FILE_UPLOAD_BYTES;
        this.name = Objects.requireNonNull(name);
        this.fileUploadPathBytes = content;
        this.filename = StringUtils.notBlank(filename) ? filename : RandomUtils.randomUUID();
        this.contentType = StringUtils.notBlank(contentType) ? contentType : MimeMapping.getMimeTypeForExtension((String)"bin");
    }

    public FormDataItem(String name, Path filePath) {
        this(name, filePath, filePath.getFileName().toString());
    }

    public FormDataItem(String name, Path filePath, String filename) {
        this(name, filePath, filename, MimeMapping.getMimeTypeForFilename((String)filename));
    }

    public FormDataItem(String name, Path filePath, String filename, String contentType) {
        this.type = FormDataItemType.FILE_UPLOAD_PATH;
        this.name = Objects.requireNonNull(name);
        this.fileUploadPath = filePath;
        this.filename = StringUtils.notBlank(filename) ? filename : RandomUtils.randomUUID();
        this.contentType = StringUtils.notBlank(contentType) ? contentType : MimeMapping.getMimeTypeForExtension((String)"bin");
    }

    public String name() {
        return this.name;
    }

    public String attributeValue() {
        return this.attributeValue;
    }

    FormDataItemType type() {
        return this.type;
    }

    public String filename() {
        return this.filename;
    }

    public Path fileUploadPath() {
        return this.fileUploadPath;
    }

    public String contentType() {
        return this.contentType;
    }

    public byte[] fileUploadPathBytes() {
        return this.fileUploadPathBytes;
    }
}

