/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.common.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomUtils {
    public static String randomString(int size, PoolType poolType) {
        byte[] pool = poolType.pool;
        byte[] value = new byte[size];
        for (int i = 0; i < size; ++i) {
            value[i] = pool[RandomUtils.randomInt(pool.length)];
        }
        return new String(value);
    }

    public static String randomString(int size) {
        return RandomUtils.randomString(size, PoolType.NUMBER_AND_LETTER);
    }

    public static String randomString(int size, String pool) {
        int[] p = pool.codePoints().toArray();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            value.appendCodePoint(p[RandomUtils.randomInt(p.length)]);
        }
        return value.toString();
    }

    public static String randomString(int size, String[] pool) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            value.append(pool[RandomUtils.randomInt(pool.length)]);
        }
        return value.toString();
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    @SafeVarargs
    public static <T> T randomGet(T ... array) {
        int i = RandomUtils.randomInt(0, array.length);
        return array[i];
    }

    public static <T> T randomGet(List<T> list) {
        Integer i = RandomUtils.randomGet(0, list.size());
        return list.get(i);
    }

    public static <T> T[] randomGet(T[] array, int size) {
        if (size > array.length) {
            throw new IndexOutOfBoundsException("\u53d6\u51fa Array \u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e \u539f Array \u7684\u957f\u5ea6 !!!");
        }
        Object[] c = Arrays.copyOf(array, array.length);
        ArrayUtils.shuffle(c);
        return Arrays.copyOf(c, size);
    }

    public static <T> List<T> randomGet(List<T> list, int size) {
        if (size > list.size()) {
            throw new IndexOutOfBoundsException("\u53d6\u51fa List \u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e \u539f List \u7684\u957f\u5ea6 !!!");
        }
        ArrayList<T> c = new ArrayList<T>(list);
        Collections.shuffle(c);
        return c.subList(0, size);
    }

    public static boolean randomBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        RandomUtils.randomBytes(bytes);
        return bytes;
    }

    public static void randomBytes(byte[] bytes) {
        ThreadLocalRandom.current().nextBytes(bytes);
    }

    public static float randomFloat() {
        return ThreadLocalRandom.current().nextFloat();
    }

    public static float randomFloat(float bound) {
        return ThreadLocalRandom.current().nextFloat(bound);
    }

    public static float randomFloat(float origin, float bound) {
        return ThreadLocalRandom.current().nextFloat(origin, bound);
    }

    public static double randomDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static double randomDouble(double bound) {
        return ThreadLocalRandom.current().nextDouble(bound);
    }

    public static double randomDouble(double origin, double bound) {
        return ThreadLocalRandom.current().nextDouble(origin, bound);
    }

    public static int randomInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static int randomInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public static int randomInt(int origin, int bound) {
        return ThreadLocalRandom.current().nextInt(origin, bound);
    }

    public static long randomLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static long randomLong(long bound) {
        return ThreadLocalRandom.current().nextLong(bound);
    }

    public static long randomLong(long origin, long bound) {
        return ThreadLocalRandom.current().nextLong(origin, bound);
    }

    public static enum PoolType {
        NUMBER(new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57}),
        LETTER(new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90}),
        NUMBER_AND_LETTER(new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90});

        final byte[] pool;

        private PoolType(byte[] pool) {
            this.pool = pool;
        }
    }
}

