/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.circular_iterable;

import cool.scx.common.util.circular_iterable.CircularIterable;
import cool.scx.common.util.circular_iterable.CircularIterator;
import cool.scx.common.util.circular_iterable.ICircularIterable;
import cool.scx.common.util.circular_iterable.ICircularIterator;
import cool.scx.common.util.circular_iterable.Node;
import cool.scx.common.util.circular_iterable.ReverseCircularIterator;
import java.util.function.IntFunction;

final class ReverseCircularIterable<T>
implements ICircularIterable<T> {
    private final CircularIterable<T> cycleIterable;

    public ReverseCircularIterable(CircularIterable<T> cycleIterable) {
        this.cycleIterable = cycleIterable;
    }

    @Override
    public T first() {
        return this.cycleIterable.last();
    }

    @Override
    public T last() {
        return this.cycleIterable.first();
    }

    @Override
    public Node<T> firstNode() {
        return this.cycleIterable.lastNode();
    }

    @Override
    public Node<T> lastNode() {
        return this.cycleIterable.firstNode();
    }

    @Override
    public int size() {
        return this.cycleIterable.size();
    }

    @Override
    public boolean add(T item) {
        return this.cycleIterable.add(item);
    }

    @Override
    public boolean remove(Object o) {
        return this.cycleIterable.remove(o);
    }

    @Override
    public void clear() {
        this.cycleIterable.clear();
    }

    @Override
    public Node<T> node(Object o) {
        return this.cycleIterable.node(o);
    }

    @Override
    public ICircularIterator<T> iterator() {
        return new ReverseCircularIterator<T>(new CircularIterator<T>(this.cycleIterable.lastNode()));
    }

    @Override
    public Object[] toArray() {
        return this.cycleIterable.toArray();
    }

    @Override
    public T[] toArray(IntFunction<T[]> generator) {
        return this.cycleIterable.toArray(generator);
    }

    @Override
    public boolean isEmpty() {
        return this.cycleIterable.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.cycleIterable.contains(o);
    }

    @Override
    public ICircularIterable<T> reversed() {
        return this.cycleIterable;
    }
}

