package cool.scx.common.util.reflect;

import java.lang.annotation.Annotation;
import java.util.ArrayList;

import static java.util.Collections.addAll;

public final class AnnotationUtils {

    public static final String NULL = """
            THIS IS A SPECIAL NULL VALUE FOR ANNOTATION - DO NOT USE
            """;

    public static String getAnnotationValue(String value) {
        if (NULL.equals(value)) {
            return null;
        } else {
            return value;
        }
    }

    public static Annotation[] findAnnotations(ClassInfo classInfo) {
        return classInfo._class().getDeclaredAnnotations();
    }

    public static Annotation[] findAnnotations(FieldInfo fieldInfo) {
        return fieldInfo._field().getDeclaredAnnotations();
    }

    public static Annotation[] findAnnotations(MethodInfo methodInfo) {
        return methodInfo._method().getDeclaredAnnotations();
    }

    /**
     * 获取当前方法的注解 同时包含 重写方法的注解
     *
     * @return a
     */
    public static Annotation[] findAllAnnotations(MethodInfo methodInfo) {
        var allAnnotations = new ArrayList<Annotation>();
        while (methodInfo != null) {
            addAll(allAnnotations, methodInfo.annotations());
            methodInfo = methodInfo.superMethod();
        }
        return allAnnotations.toArray(Annotation[]::new);
    }

    /**
     * 获取当前方法的注解 同时包含 重写方法的注解
     *
     * @return a
     */
    public static Annotation[] findAllAnnotations(ClassInfo classInfo) {
        var allAnnotations = new ArrayList<Annotation>();
        while (classInfo != null) {
            addAll(allAnnotations, classInfo.annotations());
            classInfo = classInfo.superClass();
        }
        return allAnnotations.toArray(Annotation[]::new);
    }

}
