package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;

import java.lang.annotation.Annotation;

import static cool.scx.common.util.ObjectUtils.constructType;
import static cool.scx.common.util.reflect.AnnotationUtils.findAllAnnotations;
import static cool.scx.common.util.reflect.AnnotationUtils.findAnnotations;
import static cool.scx.common.util.reflect.ClassUtils.findIsRecord;
import static cool.scx.common.util.reflect.ClassUtils.findSuperClass;
import static cool.scx.common.util.reflect.FieldUtils.findAllFieldInfos;
import static cool.scx.common.util.reflect.FieldUtils.findFieldInfos;
import static cool.scx.common.util.reflect.MethodUtils.findAllMethodInfos;
import static cool.scx.common.util.reflect.MethodUtils.findMethodInfos;

/**
 * ClassInfo
 */
public final class ClassInfo {

    private final Class<?> _class;
    private final JavaType type;
    private final ClassInfo superClass;
    private final Annotation[] annotations;
    private final FieldInfo[] fields;
    private final MethodInfo[] methods;
    private final Annotation[] allAnnotations;
    private final FieldInfo[] allFields;
    private final MethodInfo[] allMethods;
    private final boolean isRecord;

    public ClassInfo(Class<?> _class) {
        this(constructType(_class));
    }

    public ClassInfo(JavaType type) {
        this._class = type.getRawClass();
        this.type = type;
        this.isRecord = findIsRecord(this);
        this.superClass = findSuperClass(this);
        this.annotations = findAnnotations(this);
        this.fields = findFieldInfos(this);
        this.methods = findMethodInfos(this);
        this.allAnnotations = findAllAnnotations(this);
        this.allFields = findAllFieldInfos(this);
        this.allMethods = findAllMethodInfos(this);
    }

    public Class<?> _class() {
        return this._class;
    }

    public JavaType type() {
        return type;
    }

    public ClassInfo superClass() {
        return superClass;
    }

    public Annotation[] annotations() {
        return annotations;
    }

    public FieldInfo[] fields() {
        return fields;
    }

    public MethodInfo[] methods() {
        return methods;
    }

    /**
     * 获取类所有的注解 包括继承自父类的注解
     *
     * @return 所有注解
     */
    public Annotation[] allAnnotations() {
        return allAnnotations;
    }

    /**
     * 获取类所有字段 包括继承自父类的字段
     *
     * @return 所有字段
     */
    public FieldInfo[] allFields() {
        return allFields;
    }

    /**
     * 获取类所有方法 包括继承自父类的方法
     *
     * @return 所有方法
     */
    public MethodInfo[] allMethods() {
        return allMethods;
    }

    public boolean isRecord() {
        return isRecord;
    }

}
