package cool.scx.common.util.reflect;

import java.util.ArrayList;
import java.util.Arrays;

import static java.util.Collections.addAll;

public final class FieldUtils {

    public static FieldInfo[] findFieldInfos(ClassInfo classInfo) {
        return Arrays.stream(classInfo._class().getDeclaredFields()).map(field -> new FieldInfo(field, classInfo)).toArray(FieldInfo[]::new);
    }

    public static FieldInfo[] findAllFieldInfos(ClassInfo classInfo) {
        var allFieldInfos = new ArrayList<FieldInfo>();
        while (classInfo != null) {
            addAll(allFieldInfos, classInfo.fields());
            classInfo = classInfo.superClass();
        }
        return allFieldInfos.toArray(FieldInfo[]::new);
    }

    public static String findName(FieldInfo fieldInfo) {
        return fieldInfo._field().getName();
    }

}
