package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import static cool.scx.common.util.reflect.AnnotationUtils.findAllAnnotations;
import static cool.scx.common.util.reflect.AnnotationUtils.findAnnotations;
import static cool.scx.common.util.reflect.MethodUtils.findName;
import static cool.scx.common.util.reflect.MethodUtils.findSuperMethod;
import static cool.scx.common.util.reflect.ModifierHelper.findAccessModifier;
import static cool.scx.common.util.reflect.ParameterHelper.findParametersInfos;
import static cool.scx.common.util.reflect.TypeHelper.findReturnType;

/**
 * MethodInfo
 */
public final class MethodInfo {

    private final Method _method;
    private final ClassInfo classInfo;
    private final String name;
    private final Annotation[] annotations;
    private final JavaType returnType;
    private final AccessModifier accessModifier;
    private final ParameterInfo[] parameters;
    private final MethodInfo superMethod;
    private final Annotation[] allAnnotations;

    public MethodInfo(Method _method, ClassInfo classInfo) {
        this._method = _method;
        this.classInfo = classInfo;
        this.name = findName(this);
        this.annotations = findAnnotations(this);
        this.returnType = findReturnType(this);
        this.accessModifier = findAccessModifier(this);
        this.parameters = findParametersInfos(this);
        this.superMethod = findSuperMethod(this);
        this.allAnnotations = findAllAnnotations(this);
    }

    public Method _method() {
        return _method;
    }

    public ClassInfo classInfo() {
        return classInfo;
    }

    public String name() {
        return name;
    }

    public Annotation[] annotations() {
        return annotations;
    }

    public JavaType returnType() {
        return returnType;
    }

    public AccessModifier accessModifier() {
        return accessModifier;
    }

    public ParameterInfo[] parameters() {
        return parameters;
    }

    public MethodInfo superMethod() {
        return superMethod;
    }

    /**
     * 获取当前方法的注解 以及 重写的父类方法的注解
     */
    public Annotation[] allAnnotations() {
        return allAnnotations;
    }

    public void setAccessible(boolean flag) {
        this._method.setAccessible(flag);
    }

}
