package cool.scx.common.util.reflect;

import java.lang.reflect.Modifier;

import static cool.scx.common.util.reflect.AccessModifier.*;

public final class ModifierHelper {

    public static AccessModifier findAccessModifier(FieldInfo fieldInfo) {
        return findAccessModifier(fieldInfo._field().getModifiers());
    }

    public static AccessModifier findAccessModifier(MethodInfo methodInfo) {
        return findAccessModifier(methodInfo._method().getModifiers());
    }

    public static AccessModifier findAccessModifier(int m) {
        if (Modifier.isPublic(m)) {
            return PUBLIC;
        } else if (Modifier.isProtected(m)) {
            return PROTECTED;
        } else if (Modifier.isPrivate(m)) {
            return PRIVATE;
        } else {
            return DEFAULT;
        }
    }

}
