package cool.scx.common.util.reflect;

import java.util.Arrays;

public final class ParameterHelper {

    public static ParameterInfo[] findParametersInfos(MethodInfo methodInfo) {
        return Arrays.stream(methodInfo._method().getParameters()).map(parameter -> new ParameterInfo(parameter, methodInfo)).toArray(ParameterInfo[]::new);
    }

    public static String findName(ParameterInfo parameterInfo) {
        return parameterInfo._parameter().getName();
    }

}
