package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;

import java.lang.reflect.Parameter;

import static cool.scx.common.util.reflect.ParameterHelper.findName;
import static cool.scx.common.util.reflect.TypeHelper.findType;

/**
 * ParameterInfo
 */
public final class ParameterInfo {

    private final Parameter _parameter;
    private final MethodInfo methodInfo;
    private final String name;
    private final JavaType type;

    public ParameterInfo(Parameter _parameter, MethodInfo methodInfo) {
        this._parameter = _parameter;
        this.methodInfo = methodInfo;
        this.name = findName(this);
        this.type = findType(this);
    }

    public Parameter _parameter() {
        return _parameter;
    }

    public MethodInfo methodInfo() {
        return methodInfo;
    }

    public String name() {
        return name;
    }

    public JavaType type() {
        return type;
    }

}
