package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;

import static cool.scx.common.util.ObjectUtils.resolveMemberType;

public final class TypeHelper {

    public static JavaType findType(FieldInfo fieldInfo) {
        return resolveMemberType(fieldInfo._field().getGenericType(), fieldInfo.classInfo().type().getBindings());
    }

    public static JavaType findType(ParameterInfo parameterInfo) {
        return resolveMemberType(parameterInfo._parameter().getParameterizedType(), parameterInfo.methodInfo().classInfo().type().getBindings());
    }

    public static JavaType findReturnType(MethodInfo methodInfo) {
        return resolveMemberType(methodInfo._method().getGenericReturnType(), methodInfo.classInfo().type().getBindings());
    }

}
