/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.http_client.body.form_data;

import cool.scx.common.http_client.body.FormData;
import cool.scx.common.http_client.body.form_data.FormDataItem;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public final class FormDataHelper {
    public static HttpPostRequestEncoder initEncoder(FormData formData, HttpRequest request) throws HttpPostRequestEncoder.ErrorDataEncoderException, IOException {
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpDataFactory)new DefaultHttpDataFactory(), request, true, StandardCharsets.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        for (FormDataItem formDataPart : formData.items()) {
            switch (formDataPart.type()) {
                case ATTRIBUTE: {
                    encoder.addBodyAttribute(formDataPart.name(), formDataPart.attributeValue());
                    break;
                }
                case FILE_UPLOAD_PATH: {
                    encoder.addBodyFileUpload(formDataPart.name(), formDataPart.filename(), formDataPart.fileUploadPath().toFile(), formDataPart.contentType(), false);
                    break;
                }
                case FILE_UPLOAD_BYTES: {
                    MemoryFileUpload fileUpload = new MemoryFileUpload(formDataPart.name(), formDataPart.filename(), formDataPart.contentType(), null, null, (long)formDataPart.fileUploadPathBytes().length);
                    fileUpload.setContent(Unpooled.buffer().writeBytes(formDataPart.fileUploadPathBytes()));
                    encoder.addBodyHttpData((InterfaceHttpData)fileUpload);
                }
            }
        }
        encoder.finalizeRequest();
        return encoder;
    }
}

