/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.reflect;

import cool.scx.common.util.reflect.ClassInfo;
import cool.scx.common.util.reflect.FieldInfo;
import cool.scx.common.util.reflect.MethodInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;

public final class AnnotationUtils {
    public static final String NULL = "THIS IS A SPECIAL NULL VALUE FOR ANNOTATION - DO NOT USE\n";

    public static String getAnnotationValue(String value) {
        if (NULL.equals(value)) {
            return null;
        }
        return value;
    }

    public static Annotation[] findAnnotations(ClassInfo classInfo) {
        return classInfo._class().getDeclaredAnnotations();
    }

    public static Annotation[] findAnnotations(FieldInfo fieldInfo) {
        return fieldInfo._field().getDeclaredAnnotations();
    }

    public static Annotation[] findAnnotations(MethodInfo methodInfo) {
        return methodInfo._method().getDeclaredAnnotations();
    }

    public static Annotation[] findAllAnnotations(MethodInfo methodInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (methodInfo != null) {
            Collections.addAll(allAnnotations, methodInfo.annotations());
            methodInfo = methodInfo.superMethod();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }

    public static Annotation[] findAllAnnotations(ClassInfo classInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allAnnotations, classInfo.annotations());
            classInfo = classInfo.superClass();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }
}

