/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.reflect.AnnotationUtils;
import cool.scx.common.util.reflect.ClassUtils;
import cool.scx.common.util.reflect.FieldInfo;
import cool.scx.common.util.reflect.FieldUtils;
import cool.scx.common.util.reflect.MethodInfo;
import cool.scx.common.util.reflect.MethodUtils;
import java.lang.annotation.Annotation;

public final class ClassInfo {
    private final Class<?> _class;
    private final JavaType type;
    private final ClassInfo superClass;
    private final Annotation[] annotations;
    private final FieldInfo[] fields;
    private final MethodInfo[] methods;
    private final Annotation[] allAnnotations;
    private final FieldInfo[] allFields;
    private final MethodInfo[] allMethods;
    private final boolean isRecord;

    public ClassInfo(Class<?> _class) {
        this(ObjectUtils.constructType(_class));
    }

    public ClassInfo(JavaType type) {
        this._class = type.getRawClass();
        this.type = type;
        this.isRecord = ClassUtils.findIsRecord(this);
        this.superClass = ClassUtils.findSuperClass(this);
        this.annotations = AnnotationUtils.findAnnotations(this);
        this.fields = FieldUtils.findFieldInfos(this);
        this.methods = MethodUtils.findMethodInfos(this);
        this.allAnnotations = AnnotationUtils.findAllAnnotations(this);
        this.allFields = FieldUtils.findAllFieldInfos(this);
        this.allMethods = MethodUtils.findAllMethodInfos(this);
    }

    public Class<?> _class() {
        return this._class;
    }

    public JavaType type() {
        return this.type;
    }

    public ClassInfo superClass() {
        return this.superClass;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public FieldInfo[] fields() {
        return this.fields;
    }

    public MethodInfo[] methods() {
        return this.methods;
    }

    public Annotation[] allAnnotations() {
        return this.allAnnotations;
    }

    public FieldInfo[] allFields() {
        return this.allFields;
    }

    public MethodInfo[] allMethods() {
        return this.allMethods;
    }

    public boolean isRecord() {
        return this.isRecord;
    }
}

