/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.ScxExceptionHelper;
import cool.scx.common.util.StringUtils;
import cool.scx.common.util.reflect.ClassInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public final class ClassUtils {
    private static final ClassLoader DEFAULT_CLASS_LOADER = ClassUtils.class.getClassLoader();

    public static List<Class<?>> getClassListFromJar(URI jarFileURI) throws IOException {
        try (JarFile jarFile = new JarFile(new File(jarFileURI));){
            List<Class<?>> list;
            try (URLClassLoader jarClassLoader = new URLClassLoader(new URL[]{jarFileURI.toURL()});){
                list = jarFile.stream().filter(jarEntry -> !jarEntry.isDirectory() && jarEntry.getName().endsWith(".class")).map(jarEntry -> ClassUtils.loadClass(jarEntry, (ClassLoader)jarClassLoader)).collect(Collectors.toList());
            }
            return list;
        }
    }

    public static List<Class<?>> getClassListFromDir(final Path classRootPath, final ClassLoader classLoader) throws IOException {
        final ArrayList classList = new ArrayList();
        Files.walkFileTree(classRootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                if (path.toString().endsWith(".class")) {
                    Path classRealPath = classRootPath.relativize(path);
                    classList.add(ClassUtils.loadClass(classRealPath, classLoader));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return classList;
    }

    private static Class<?> loadClass(JarEntry jarEntry, ClassLoader jarClassLoader) {
        int suffixLength = ".class".length();
        String className = jarEntry.getName().substring(0, jarEntry.getName().length() - suffixLength).replace('/', '.');
        return ClassUtils.loadClass0(className, jarClassLoader);
    }

    private static Class<?> loadClass(Path classRealPath, ClassLoader classLoader) {
        int suffixLength = ".class.".length();
        StringBuilder str = new StringBuilder();
        for (Path path : classRealPath) {
            str.append(path.toString()).append(".");
        }
        String className = str.substring(0, str.length() - suffixLength);
        return ClassUtils.loadClass0(className, classLoader);
    }

    public static URI getCodeSource(Class<?> source) {
        return URI.create(source.getProtectionDomain().getCodeSource().getLocation().toString());
    }

    public static Path getAppRoot(URI codeSource) {
        Path path = Path.of(codeSource);
        return Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
    }

    public static Path getAppRoot(Class<?> source) {
        return ClassUtils.getAppRoot(ClassUtils.getCodeSource(source));
    }

    private static Class<?> loadClass0(String className, ClassLoader classLoader) {
        try {
            return DEFAULT_CLASS_LOADER.loadClass(className);
        }
        catch (Throwable t1) {
            try {
                return classLoader.loadClass(className);
            }
            catch (Throwable t2) {
                return null;
            }
        }
    }

    public static List<Class<?>> filterByBasePackage(List<Class<?>> classList, String basePackageName) {
        String p = basePackageName + ".";
        return classList.stream().filter(c -> {
            String cp = c.getPackageName();
            return cp.equals(basePackageName) || cp.startsWith(p);
        }).toList();
    }

    public static boolean isJar(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]) && StringUtils.endsWithIgnoreCase(path.toString(), ".jar");
    }

    public static boolean isInstantiableClass(Class<?> c) {
        return ClassUtils.isNormalClass(c) && ScxExceptionHelper.noException(() -> c.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    public static boolean isNormalClass(Class<?> c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }

    public static boolean isEnum(Class<?> c) {
        return Enum.class.isAssignableFrom(c);
    }

    public static ClassInfo findSuperClass(ClassInfo classInfo) {
        return classInfo.type().getSuperClass() != null ? new ClassInfo(classInfo.type().getSuperClass()) : null;
    }

    public static JavaType findSuperClassByType(Class<?> clazz, Class<?> superClass) {
        JavaType t;
        for (t = ObjectUtils.constructType(clazz); t != null && t.getRawClass() != superClass; t = t.getSuperClass()) {
        }
        return t;
    }

    public static boolean findIsRecord(ClassInfo classInfo) {
        return classInfo._class().isRecord();
    }
}

