/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.reflect;

import cool.scx.common.util.reflect.ClassInfo;
import cool.scx.common.util.reflect.FieldInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public final class FieldUtils {
    public static FieldInfo[] findFieldInfos(ClassInfo classInfo) {
        return (FieldInfo[])Arrays.stream(classInfo._class().getDeclaredFields()).map(field -> new FieldInfo((Field)field, classInfo)).toArray(FieldInfo[]::new);
    }

    public static FieldInfo[] findAllFieldInfos(ClassInfo classInfo) {
        ArrayList allFieldInfos = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allFieldInfos, classInfo.fields());
            classInfo = classInfo.superClass();
        }
        return (FieldInfo[])allFieldInfos.toArray(FieldInfo[]::new);
    }

    public static String findName(FieldInfo fieldInfo) {
        return fieldInfo._field().getName();
    }
}

