/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.reflect;

import cool.scx.common.util.reflect.AccessModifier;
import cool.scx.common.util.reflect.ClassInfo;
import cool.scx.common.util.reflect.MethodInfo;
import cool.scx.common.util.reflect.ParameterInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public final class MethodUtils {
    public static MethodInfo[] findMethodInfos(ClassInfo classInfo) {
        return (MethodInfo[])Arrays.stream(classInfo._class().getDeclaredMethods()).filter(method -> !method.isBridge()).map(method -> new MethodInfo((Method)method, classInfo)).toArray(MethodInfo[]::new);
    }

    public static MethodInfo findSuperMethod(MethodInfo methodInfo) {
        for (ClassInfo superClass = methodInfo.classInfo().superClass(); superClass != null; superClass = superClass.superClass()) {
            MethodInfo[] superMethods;
            for (MethodInfo superMethod : superMethods = superClass.methods()) {
                boolean b = MethodUtils.isOverride(methodInfo, superMethod);
                if (!b) continue;
                return superMethod;
            }
        }
        return null;
    }

    public static MethodInfo[] findAllMethodInfos(ClassInfo classInfo) {
        HashSet<MethodInfo> filter = new HashSet<MethodInfo>();
        ArrayList<MethodInfo> allMethodInfo = new ArrayList<MethodInfo>();
        while (classInfo != null) {
            MethodInfo[] methods;
            for (MethodInfo method : methods = classInfo.methods()) {
                boolean b;
                if (method.superMethod() != null) {
                    filter.add(method.superMethod());
                }
                if (b = filter.contains(method)) continue;
                allMethodInfo.add(method);
            }
            classInfo = classInfo.superClass();
        }
        return (MethodInfo[])allMethodInfo.toArray(MethodInfo[]::new);
    }

    public static String findName(MethodInfo methodInfo) {
        return methodInfo._method().getName();
    }

    private static boolean isOverride(MethodInfo rootMethod, MethodInfo candidateMethod) {
        return AccessModifier.PRIVATE != candidateMethod.accessModifier() && candidateMethod.name().equals(rootMethod.name()) && MethodUtils.hasSameParameterTypes(rootMethod, candidateMethod);
    }

    private static boolean hasSameParameterTypes(MethodInfo rootMethod, MethodInfo candidateMethod) {
        if (candidateMethod.parameters().length != rootMethod.parameters().length) {
            return false;
        }
        ParameterInfo[] p1 = rootMethod.parameters();
        ParameterInfo[] p2 = candidateMethod.parameters();
        for (int i = 0; i < p1.length; ++i) {
            Class p2Type;
            Class p1Type = p1[i].type().getRawClass();
            if (p1Type == (p2Type = p2[i].type().getRawClass())) continue;
            return false;
        }
        return true;
    }
}

