/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.http_client;

import cool.scx.common.http_client.ScxHttpClientOptions;
import cool.scx.common.http_client.ScxHttpClientRequest;
import cool.scx.common.http_client.ScxHttpClientResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.util.concurrent.CompletableFuture;

public class ScxHttpClient {
    private final HttpClient client;

    public ScxHttpClient() {
        this(new ScxHttpClientOptions());
    }

    public ScxHttpClient(ScxHttpClientOptions options) {
        this(options.toHttpClientBuilder());
    }

    public ScxHttpClient(HttpClient.Builder builder) {
        this.client = builder.build();
    }

    public CompletableFuture<WebSocket> webSocket(URI uri, WebSocket.Listener listener) {
        return this.client.newWebSocketBuilder().buildAsync(uri, listener);
    }

    public ScxHttpClientResponse request(ScxHttpClientRequest request) throws IOException, InterruptedException {
        HttpResponse<InputStream> response = this.client.send(request.createHttpRequest(), HttpResponse.BodyHandlers.ofInputStream());
        return new ScxHttpClientResponse(response);
    }

    public CompletableFuture<ScxHttpClientResponse> requestAsync(ScxHttpClientRequest request) {
        CompletableFuture<HttpResponse<InputStream>> future = this.client.sendAsync(request.createHttpRequest(), HttpResponse.BodyHandlers.ofInputStream());
        return future.thenApply(ScxHttpClientResponse::new);
    }
}

