/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import io.vertx.core.Future;
import java.util.function.Consumer;

public final class SingleListenerFuture<T> {
    private final Future<T> vertxFuture;
    private volatile Consumer<T> _onSuccess;
    private volatile Consumer<Throwable> _onFailure;

    public SingleListenerFuture(Future<T> vertxFuture) {
        this.vertxFuture = vertxFuture;
        this.vertxFuture.onSuccess(this::_callOnSuccess).onFailure(this::_callOnFailure);
    }

    public synchronized boolean isComplete() {
        return this.vertxFuture.isComplete();
    }

    public synchronized SingleListenerFuture<T> onSuccess(Consumer<T> onSuccess) {
        if (this.vertxFuture.succeeded()) {
            if (onSuccess != null) {
                onSuccess.accept(this.vertxFuture.result());
            }
        } else {
            this._onSuccess = onSuccess;
        }
        return this;
    }

    public synchronized SingleListenerFuture<T> onFailure(Consumer<Throwable> onFailure) {
        if (this.vertxFuture.failed()) {
            if (onFailure != null) {
                onFailure.accept(this.vertxFuture.cause());
            }
        } else {
            this._onFailure = onFailure;
        }
        return this;
    }

    private synchronized void _callOnSuccess(T t) {
        if (this._onSuccess != null) {
            this._onSuccess.accept(t);
        }
    }

    private synchronized void _callOnFailure(Throwable throwable) {
        if (this._onFailure != null) {
            this._onFailure.accept(throwable);
        }
    }

    public Future<T> vertxFuture() {
        return this.vertxFuture;
    }
}

