/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.ansi;

import cool.scx.common.ansi.Ansi8BitBackground;
import cool.scx.common.ansi.Ansi8BitColor;
import cool.scx.common.ansi.AnsiBackground;
import cool.scx.common.ansi.AnsiColor;
import cool.scx.common.ansi.AnsiElement;
import cool.scx.common.ansi.AnsiHelper;
import cool.scx.common.ansi.AnsiItem;
import cool.scx.common.ansi.AnsiStyle;
import cool.scx.common.util.ArrayUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public final class Ansi {
    private static final boolean enabled = AnsiHelper.detectIfAnsiCapable();
    private final List<AnsiItem> items = new ArrayList<AnsiItem>();

    private Ansi() {
    }

    public static Ansi ansi() {
        return new Ansi();
    }

    private static void buildEnabled(StringBuilder sb, List<AnsiItem> elements) {
        for (AnsiItem element : elements) {
            element.buildEnabled(sb);
        }
    }

    private static void buildDisabled(StringBuilder sb, List<AnsiItem> elements) {
        for (AnsiItem element : elements) {
            element.buildDisabled(sb);
        }
    }

    private static AnsiElement[] filterAnsiElement(AnsiElement ... elements) {
        if (elements.length == 0) {
            return elements;
        }
        AnsiElement ansiColor = null;
        AnsiElement ansiBackground = null;
        LinkedHashSet<AnsiStyle> ansiStyleSet = new LinkedHashSet<AnsiStyle>();
        for (AnsiElement element : elements) {
            if (element instanceof AnsiColor || element instanceof Ansi8BitColor) {
                ansiColor = element;
                continue;
            }
            if (element instanceof AnsiBackground || element instanceof Ansi8BitBackground) {
                ansiBackground = element;
                continue;
            }
            if (!(element instanceof AnsiStyle)) continue;
            AnsiStyle ansiStyle = (AnsiStyle)element;
            ansiStyleSet.add(ansiStyle);
        }
        ArrayList<AnsiElement> l = new ArrayList<AnsiElement>();
        if (ansiColor != null) {
            l.add(ansiColor);
        }
        if (ansiBackground != null) {
            l.add(ansiBackground);
        }
        l.addAll(ansiStyleSet);
        return (AnsiElement[])l.toArray(AnsiElement[]::new);
    }

    public Ansi ln() {
        return this.add(System.lineSeparator(), new AnsiElement[0]);
    }

    public Ansi add(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements)));
        return this;
    }

    public void print() {
        System.out.print(this);
    }

    public void print(boolean useAnsi) {
        System.out.print(this.toString(useAnsi));
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean useAnsi) {
        StringBuilder sb = new StringBuilder();
        if (enabled && useAnsi) {
            Ansi.buildEnabled(sb, this.items);
        } else {
            Ansi.buildDisabled(sb, this.items);
        }
        return sb.toString();
    }

    public void println() {
        this.ln().print();
    }

    public void println(boolean useAnsi) {
        this.ln().print(useAnsi);
    }

    public Ansi red(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.RED));
    }

    public Ansi green(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.GREEN));
    }

    public Ansi brightCyan(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BRIGHT_CYAN));
    }

    public Ansi blue(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BLUE));
    }

    public Ansi cyan(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.CYAN));
    }

    public Ansi brightBlue(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BRIGHT_BLUE));
    }

    public Ansi brightMagenta(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BRIGHT_MAGENTA));
    }

    public Ansi brightRed(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BRIGHT_RED));
    }

    public Ansi brightGreen(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BRIGHT_GREEN));
    }

    public Ansi black(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BLACK));
    }

    public Ansi brightBlack(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BRIGHT_BLACK));
    }

    public Ansi brightYellow(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BRIGHT_YELLOW));
    }

    public Ansi yellow(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.YELLOW));
    }

    public Ansi magenta(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.MAGENTA));
    }

    public Ansi white(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.WHITE));
    }

    public Ansi brightWhite(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.BRIGHT_WHITE));
    }

    public Ansi defaultColor(Object o, AnsiElement ... ansiElements) {
        return this.add(o, ArrayUtils.concat(ansiElements, AnsiColor.DEFAULT));
    }
}

