/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.common.util.StringUtils;
import io.vertx.core.http.HttpServerRequest;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.function.Predicate;

public final class NetUtils {
    public static String getClientIPAddress(HttpServerRequest request) {
        String[] s;
        String xRealIPStr = request.getHeader("X-Real-IP");
        if (StringUtils.notBlank(xRealIPStr) && !"unknown".equalsIgnoreCase(xRealIPStr)) {
            return xRealIPStr;
        }
        String xForwardedForStr = request.getHeader("X-Forwarded-For");
        if (StringUtils.notBlank(xForwardedForStr) && !"unknown".equalsIgnoreCase(xForwardedForStr) && (s = xForwardedForStr.split(",")).length > 0) {
            return s[0];
        }
        String remoteAddressStr = request.remoteAddress().hostAddress();
        if ("0:0:0:0:0:0:0:1".equals(remoteAddressStr)) {
            return "127.0.0.1";
        }
        return remoteAddressStr;
    }

    public static InetAddress[] getLocalIPAddress(Predicate<InetAddress> filter) throws SocketException {
        return (InetAddress[])NetworkInterface.networkInterfaces().flatMap(NetworkInterface::inetAddresses).filter(c -> !c.isLoopbackAddress() && filter.test((InetAddress)c)).toArray(InetAddress[]::new);
    }

    public static InetAddress[] getLocalIPAddress() throws SocketException {
        return NetUtils.getLocalIPAddress(c -> true);
    }
}

