/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;

public final class FileWatcher {
    private final WatchService watchService = FileSystems.getDefault().newWatchService();
    private final Path fileName;
    private Thread watchThread;
    private Runnable deleteHandler;
    private Runnable createHandler;
    private Runnable modifyHandler;

    public FileWatcher(Path path) throws IOException {
        this.fileName = path.getFileName();
        Path fileParent = path.getParent();
        fileParent.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public void _do() {
        WatchKey watchKey;
        boolean valid;
        do {
            try {
                watchKey = this.watchService.take();
            }
            catch (InterruptedException e) {
                break;
            }
            List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
            for (WatchEvent<?> event : watchEvents) {
                Path context = (Path)event.context();
                if (!this.fileName.equals(context)) continue;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    this._callOnCreate();
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    this._callOnModify();
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                this._callOnDelete();
            }
        } while (valid = watchKey.reset());
    }

    public FileWatcher onCreate(Runnable createHandler) {
        this.createHandler = createHandler;
        return this;
    }

    public FileWatcher onModify(Runnable modifyHandler) {
        this.modifyHandler = modifyHandler;
        return this;
    }

    public FileWatcher onDelete(Runnable deleteHandler) {
        this.deleteHandler = deleteHandler;
        return this;
    }

    private void _callOnCreate() {
        if (this.createHandler != null) {
            this.createHandler.run();
        }
    }

    private void _callOnModify() {
        if (this.modifyHandler != null) {
            this.modifyHandler.run();
        }
    }

    private void _callOnDelete() {
        if (this.deleteHandler != null) {
            this.deleteHandler.run();
        }
    }

    public synchronized void start() {
        this.watchThread = Thread.ofVirtual().start(this::_do);
    }

    public synchronized void stop() {
        if (this.watchThread != null) {
            this.watchThread.interrupt();
            this.watchThread = null;
        }
    }
}

