/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.common.util.ScxExceptionHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class ScopedValue<T> {
    private static final AtomicLong THREAD_NUMBER = new AtomicLong(0L);
    private final InheritableThreadLocal<T> threadLocal = new InheritableThreadLocal();

    public static <T> ScopedValue<T> newInstance() {
        return new ScopedValue<T>();
    }

    public static <T> Carrier<T> where(ScopedValue<T> key, T value) {
        return new Carrier<T>(key, value);
    }

    void bind(T value) {
        this.threadLocal.set(value);
    }

    public T get() {
        return this.threadLocal.get();
    }

    public static final class Carrier<T> {
        private final T value;
        private final ScopedValue<T> key;

        public Carrier(ScopedValue<T> key, T value) {
            this.key = key;
            this.value = value;
        }

        public void run(Runnable op) {
            AtomicReference exception = new AtomicReference();
            Thread w = Thread.ofVirtual().name("scx-scoped-value-thread-", THREAD_NUMBER.getAndIncrement()).start(() -> {
                this.key.bind(this.value);
                try {
                    op.run();
                }
                catch (Exception e) {
                    exception.set(e);
                }
            });
            try {
                w.join();
            }
            catch (InterruptedException e) {
                throw new ScxExceptionHelper.ScxWrappedRuntimeException(e);
            }
            if (exception.get() != null) {
                throw new ScxExceptionHelper.ScxWrappedRuntimeException((Throwable)exception.get());
            }
        }

        public <R> R get(Supplier<? extends R> op) {
            AtomicReference result = new AtomicReference();
            AtomicReference exception = new AtomicReference();
            Thread w = Thread.ofVirtual().name("scx-scoped-value-thread-", THREAD_NUMBER.getAndIncrement()).start(() -> {
                this.key.bind(this.value);
                try {
                    Object r = op.get();
                    result.set(r);
                }
                catch (Exception e) {
                    exception.set(e);
                }
            });
            try {
                w.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (exception.get() != null) {
                throw new ScxExceptionHelper.ScxWrappedRuntimeException((Throwable)exception.get());
            }
            return (R)result.get();
        }

        public <R> R call(Callable<? extends R> op) throws Exception {
            AtomicReference result = new AtomicReference();
            AtomicReference exception = new AtomicReference();
            Thread w = Thread.ofVirtual().name("scx-scoped-value-thread-", THREAD_NUMBER.getAndIncrement()).start(() -> {
                this.key.bind(this.value);
                try {
                    Object r = op.call();
                    result.set(r);
                }
                catch (Exception e) {
                    exception.set(e);
                }
            });
            try {
                w.join();
            }
            catch (InterruptedException e) {
                throw new ScxExceptionHelper.ScxWrappedRuntimeException(e);
            }
            if (exception.get() != null) {
                throw (Exception)exception.get();
            }
            return (R)result.get();
        }
    }
}

