/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.ansi;

import cool.scx.common.ansi.AnsiElement;
import cool.scx.common.ansi.AnsiStyle;
import java.util.StringJoiner;

public record AnsiItem(Object value, AnsiElement[] elements) {
    private static final String ENCODE_START = "\u001b[";
    private static final String ENCODE_JOIN = ";";
    private static final String ENCODE_END = "m";

    public static String joinAnsiElement(AnsiElement ... elements) {
        StringJoiner joiner = new StringJoiner(ENCODE_JOIN);
        for (AnsiElement element : elements) {
            joiner.add(element.code());
        }
        return joiner.toString();
    }

    public void buildEnabled(StringBuilder sb) {
        if (this.elements.length == 0) {
            this.buildDisabled(sb);
            return;
        }
        sb.append(ENCODE_START);
        sb.append(AnsiItem.joinAnsiElement(this.elements));
        sb.append(ENCODE_END);
        sb.append(this.value);
        sb.append(ENCODE_START);
        sb.append(AnsiStyle.NORMAL.code());
        sb.append(ENCODE_END);
    }

    public void buildDisabled(StringBuilder sb) {
        sb.append(this.value);
    }
}

