/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.field_filter.deserializer;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.field_filter.ExcludedFieldFilter;
import cool.scx.common.field_filter.FieldFilter;
import cool.scx.common.field_filter.FilterMode;
import cool.scx.common.field_filter.IncludedFieldFilter;
import cool.scx.common.util.ObjectUtils;

public class FieldFilterDeserializer {
    public static final FieldFilterDeserializer FIELD_FILTER_DESERIALIZER = new FieldFilterDeserializer();

    public Object deserialize(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("FieldFilter")) {
            return this.deserializeFieldFilter(v);
        }
        return null;
    }

    public FieldFilter deserializeFieldFilter(JsonNode objectNode) {
        if (objectNode == null) {
            return FieldFilter.ofExcluded(new String[0]);
        }
        FilterMode filterMode = FilterMode.of(objectNode.get("filterMode").textValue());
        String[] fieldNames = ObjectUtils.convertValue((Object)objectNode.get("fieldNames"), String[].class);
        boolean ignoreNullValue = objectNode.get("ignoreNullValue").asBoolean();
        if (filterMode == FilterMode.INCLUDED) {
            return new IncludedFieldFilter().addIncluded(fieldNames).ignoreNullValue(ignoreNullValue);
        }
        if (filterMode == FilterMode.EXCLUDED) {
            return new ExcludedFieldFilter().addIncluded(fieldNames).ignoreNullValue(ignoreNullValue);
        }
        return null;
    }
}

