/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.http_client.request_body;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.http_client.ScxHttpClientRequestBody;
import cool.scx.common.standard.HttpFieldName;
import cool.scx.common.standard.MediaType;
import cool.scx.common.util.ObjectUtils;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;

public final class JsonBody
implements ScxHttpClientRequestBody {
    private final String bodyStr;

    public JsonBody(Object o) throws JsonProcessingException {
        this.bodyStr = ObjectUtils.toJson(o);
    }

    public JsonBody(String json) {
        this.bodyStr = json;
    }

    @Override
    public HttpRequest.BodyPublisher bodyPublisher(HttpRequest.Builder builder) {
        builder.setHeader(HttpFieldName.CONTENT_TYPE.toString(), MediaType.APPLICATION_JSON.toString(StandardCharsets.UTF_8));
        return HttpRequest.BodyPublishers.ofByteArray(this.bodyStr.getBytes(StandardCharsets.UTF_8));
    }
}

