/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.reflect.ConstructorInfo;
import cool.scx.common.reflect.FieldInfo;
import cool.scx.common.reflect.MethodInfo;
import cool.scx.common.reflect.ReflectFactory;
import java.lang.annotation.Annotation;

public final class ClassInfo {
    private final JavaType type;
    private final ClassInfo superClass;
    private final ClassInfo[] interfaces;
    private final boolean isRecord;
    private final boolean isInterface;
    private final boolean isAbstract;
    private final boolean isEnum;
    private final boolean isAnonymousClass;
    private final Annotation[] annotations;
    private final ConstructorInfo[] constructors;
    private final FieldInfo[] fields;
    private final MethodInfo[] methods;
    private final Annotation[] allAnnotations;
    private final FieldInfo[] allFields;
    private final MethodInfo[] allMethods;
    private final ConstructorInfo noArgsConstructor;
    private final ConstructorInfo recordConstructor;
    private final ClassInfo enumClass;

    ClassInfo(JavaType type) {
        this.type = type;
        this.superClass = ReflectFactory._findSuperClass(this);
        this.interfaces = ReflectFactory._findInterfaces(this);
        this.isRecord = ReflectFactory._isRecord(this);
        this.isInterface = ReflectFactory._isInterface(this);
        this.isAbstract = ReflectFactory._isAbstract(this);
        this.isEnum = ReflectFactory._isEnum(this);
        this.isAnonymousClass = ReflectFactory._isAnonymousClass(this);
        this.annotations = ReflectFactory._findAnnotations(this);
        this.constructors = ReflectFactory._findConstructorInfos(this);
        this.fields = ReflectFactory._findFieldInfos(this);
        this.methods = ReflectFactory._findMethodInfos(this);
        this.allAnnotations = ReflectFactory._findAllAnnotations(this);
        this.allFields = ReflectFactory._findAllFieldInfos(this);
        this.allMethods = ReflectFactory._findAllMethodInfos(this);
        this.noArgsConstructor = ReflectFactory._findNoArgsConstructor(this);
        this.recordConstructor = ReflectFactory._findRecordConstructor(this);
        this.enumClass = ReflectFactory._findEnumClass(this);
    }

    public JavaType type() {
        return this.type;
    }

    public ClassInfo superClass() {
        return this.superClass;
    }

    public ClassInfo[] interfaces() {
        return this.interfaces;
    }

    public boolean isRecord() {
        return this.isRecord;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isAnonymousClass() {
        return this.isAnonymousClass;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public ConstructorInfo[] constructors() {
        return this.constructors;
    }

    public FieldInfo[] fields() {
        return this.fields;
    }

    public MethodInfo[] methods() {
        return this.methods;
    }

    public Annotation[] allAnnotations() {
        return this.allAnnotations;
    }

    public FieldInfo[] allFields() {
        return this.allFields;
    }

    public MethodInfo[] allMethods() {
        return this.allMethods;
    }

    public ConstructorInfo noArgsConstructor() {
        return this.noArgsConstructor;
    }

    public ConstructorInfo recordConstructor() {
        return this.recordConstructor;
    }

    public ClassInfo enumClass() {
        return this.enumClass;
    }

    public ClassInfo findSuperType(Class<?> rawTarget) {
        if (rawTarget == this.type.getRawClass()) {
            return this;
        }
        if (rawTarget.isInterface()) {
            for (ClassInfo anInterface : this.interfaces) {
                ClassInfo type = anInterface.findSuperType(rawTarget);
                if (type == null) continue;
                return type;
            }
        }
        if (this.superClass != null) {
            return this.superClass.findSuperType(rawTarget);
        }
        return null;
    }
}

