/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.tree;

import cool.scx.common.util.MultiMap;
import cool.scx.common.util.tree.ScxTree;
import cool.scx.common.util.tree.ScxTreeModel;
import cool.scx.common.util.tree.ScxTreeVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ScxTreeUtils {
    public static <T extends ScxTree<T>> void walk(T scxTree, ScxTreeVisitor<T> visitor) {
        ScxTreeUtils._walk(null, scxTree, visitor);
    }

    private static <T extends ScxTree<T>> void _walk(List<T> parents, T currentScxTree, ScxTreeVisitor<T> visitor) {
        visitor.handle(parents, currentScxTree);
        ArrayList<T> newParents = parents == null ? new ArrayList<T>() : new ArrayList<T>(parents);
        newParents.add(currentScxTree);
        if (currentScxTree.children() != null) {
            for (ScxTree child : currentScxTree.children()) {
                ScxTreeUtils._walk(newParents, child, visitor);
            }
        }
    }

    public static <T extends ScxTreeModel<T>> List<T> listToTree(List<T> list) {
        return ScxTreeUtils.listToTree(list, false);
    }

    public static <T extends ScxTreeModel<T>> List<T> listToTree(List<T> list, boolean ignoreOrphans) {
        if (list == null) {
            throw new IllegalArgumentException("listToTree : \u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        HashMap<Object, ScxTreeModel> idMap = new HashMap<Object, ScxTreeModel>(list.size());
        MultiMap<Object, ScxTreeModel> parentIDMap = new MultiMap<Object, ScxTreeModel>();
        for (ScxTreeModel t : list) {
            idMap.put(t.id(), t);
            parentIDMap.put(t.parentID(), t);
        }
        return list.stream().filter(my -> {
            List myChildren;
            boolean isOrphan;
            Object myID = my.id();
            Object parentID = my.parentID();
            boolean bl = isOrphan = !ignoreOrphans && (parentID == null || idMap.get(parentID) == null);
            if (myID != null && (myChildren = parentIDMap.get(myID)).size() > 0) {
                my.children(myChildren);
            }
            return my.isRoot() || isOrphan;
        }).toList();
    }
}

