/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.field_filter.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.field_filter.ExcludedFieldFilter;
import cool.scx.common.field_filter.FieldFilter;
import cool.scx.common.field_filter.FilterMode;
import cool.scx.common.field_filter.IncludedFieldFilter;
import cool.scx.common.util.ObjectUtils;

public class FieldFilterDeserializer {
    public static final FieldFilterDeserializer FIELD_FILTER_DESERIALIZER = new FieldFilterDeserializer();

    public Object deserialize(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("FieldFilter")) {
            return this.deserializeFieldFilter(v);
        }
        return v;
    }

    public FieldFilter deserializeFieldFilter(JsonNode objectNode) {
        if (objectNode == null) {
            return new ExcludedFieldFilter();
        }
        FilterMode filterMode = ObjectUtils.convertValue((Object)objectNode.get("filterMode"), FilterMode.class);
        String[] fieldNames = ObjectUtils.convertValue((Object)objectNode.get("fieldNames"), String[].class);
        boolean ignoreNullValue = objectNode.get("ignoreNullValue").asBoolean();
        return switch (filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.INCLUDED -> new IncludedFieldFilter().addIncluded(fieldNames).ignoreNullValue(ignoreNullValue);
            case FilterMode.EXCLUDED -> new ExcludedFieldFilter().addExcluded(fieldNames).ignoreNullValue(ignoreNullValue);
        };
    }
}

