/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.field_filter.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.field_filter.FieldFilter;
import cool.scx.common.field_filter.FieldFilterImpl;
import cool.scx.common.field_filter.FilterMode;
import cool.scx.common.util.ObjectUtils;

public class FieldFilterDeserializer {
    public static final FieldFilterDeserializer FIELD_FILTER_DESERIALIZER = new FieldFilterDeserializer();

    public Object deserialize(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("FieldFilter")) {
            return this.deserializeFieldFilter(v);
        }
        return v;
    }

    public FieldFilter deserializeFieldFilter(JsonNode objectNode) {
        FilterMode filterMode = FilterMode.EXCLUDED;
        if (objectNode == null) {
            return new FieldFilterImpl(filterMode);
        }
        if (objectNode.get("filterMode") != null && !objectNode.get("filterMode").isNull()) {
            filterMode = ObjectUtils.convertValue((Object)objectNode.get("filterMode"), FilterMode.class);
        }
        FieldFilterImpl fieldFilter = new FieldFilterImpl(filterMode);
        if (objectNode.get("fieldNames") != null && !objectNode.get("fieldNames").isNull()) {
            String[] fieldNames = ObjectUtils.convertValue((Object)objectNode.get("fieldNames"), String[].class);
            fieldFilter.addFieldNames(fieldNames);
        }
        if (objectNode.get("ignoreNullValue") != null && !objectNode.get("ignoreNullValue").isNull()) {
            boolean ignoreNullValue = objectNode.get("ignoreNullValue").asBoolean();
            fieldFilter.ignoreNullValue(ignoreNullValue);
        }
        return fieldFilter;
    }
}

