/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.reflect.AccessModifier;
import cool.scx.common.reflect.ClassInfo;
import cool.scx.common.reflect.ConstructorInfo;
import cool.scx.common.reflect.FieldInfo;
import cool.scx.common.reflect.MethodInfo;
import cool.scx.common.reflect.ParameterInfo;
import cool.scx.common.util.ObjectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ReflectFactory {
    private static final Map<JavaType, ClassInfo> CLASS_INFO_CACHE = new HashMap<JavaType, ClassInfo>();

    public static ClassInfo getClassInfo(Class<?> javaType) {
        return ReflectFactory.getClassInfo(ObjectUtils.constructType(javaType));
    }

    public static ClassInfo getClassInfo(JavaType javaType) {
        ClassInfo classInfo = CLASS_INFO_CACHE.get(javaType);
        if (classInfo == null) {
            classInfo = new ClassInfo(javaType);
            CLASS_INFO_CACHE.put(javaType, classInfo);
        }
        return classInfo;
    }

    private static AccessModifier _findAccessModifier(int m) {
        if (Modifier.isPublic(m)) {
            return AccessModifier.PUBLIC;
        }
        if (Modifier.isProtected(m)) {
            return AccessModifier.PROTECTED;
        }
        if (Modifier.isPrivate(m)) {
            return AccessModifier.PRIVATE;
        }
        return AccessModifier.DEFAULT;
    }

    private static JavaType _findType(Type type, ClassInfo classInfo) {
        return ObjectUtils.resolveMemberType(type, classInfo.type().getBindings());
    }

    static ClassInfo _findSuperClass(ClassInfo classInfo) {
        return classInfo.type().getSuperClass() != null ? ReflectFactory.getClassInfo(classInfo.type().getSuperClass()) : null;
    }

    static ClassInfo[] _findInterfaces(ClassInfo classInfo) {
        List interfaces = classInfo.type().getInterfaces();
        ClassInfo[] result = new ClassInfo[interfaces.size()];
        for (int i = 0; i < interfaces.size(); ++i) {
            result[i] = ReflectFactory.getClassInfo((JavaType)interfaces.get(i));
        }
        return result;
    }

    static boolean _isRecord(ClassInfo classInfo) {
        return classInfo.type().getRawClass().isRecord();
    }

    static boolean _isInterface(ClassInfo classInfo) {
        return classInfo.type().getRawClass().isInterface();
    }

    static boolean _isAbstract(ClassInfo classInfo) {
        return Modifier.isAbstract(classInfo.type().getRawClass().getModifiers());
    }

    static boolean _isEnum(ClassInfo classInfo) {
        return Enum.class.isAssignableFrom(classInfo.type().getRawClass());
    }

    static boolean _isAnonymousClass(ClassInfo classInfo) {
        return classInfo.type().getRawClass().isAnonymousClass();
    }

    static Annotation[] _findAnnotations(ClassInfo classInfo) {
        return classInfo.type().getRawClass().getDeclaredAnnotations();
    }

    static ConstructorInfo[] _findConstructorInfos(ClassInfo classInfo) {
        Constructor<?>[] constructors = classInfo.type().getRawClass().getDeclaredConstructors();
        ConstructorInfo[] result = new ConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new ConstructorInfo(constructors[i], classInfo);
        }
        return result;
    }

    static FieldInfo[] _findFieldInfos(ClassInfo classInfo) {
        Field[] fields = classInfo.type().getRawClass().getDeclaredFields();
        FieldInfo[] result = new FieldInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = new FieldInfo(fields[i], classInfo);
        }
        return result;
    }

    static MethodInfo[] _findMethodInfos(ClassInfo classInfo) {
        Method[] methods = classInfo.type().getRawClass().getDeclaredMethods();
        ArrayList<MethodInfo> list = new ArrayList<MethodInfo>();
        for (Method method : methods) {
            if (method.isBridge()) continue;
            list.add(new MethodInfo(method, classInfo));
        }
        return (MethodInfo[])list.toArray(MethodInfo[]::new);
    }

    static Annotation[] _findAllAnnotations(ClassInfo classInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allAnnotations, classInfo.annotations());
            classInfo = classInfo.superClass();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }

    static FieldInfo[] _findAllFieldInfos(ClassInfo classInfo) {
        ArrayList allFieldInfos = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allFieldInfos, classInfo.fields());
            classInfo = classInfo.superClass();
        }
        return (FieldInfo[])allFieldInfos.toArray(FieldInfo[]::new);
    }

    static MethodInfo[] _findAllMethodInfos(ClassInfo classInfo) {
        HashSet<MethodInfo> filter = new HashSet<MethodInfo>();
        ArrayList<MethodInfo> allMethodInfo = new ArrayList<MethodInfo>();
        while (classInfo != null) {
            MethodInfo[] methods;
            for (MethodInfo method : methods = classInfo.methods()) {
                boolean b;
                if (method.superMethod() != null) {
                    filter.add(method.superMethod());
                }
                if (b = filter.contains(method)) continue;
                allMethodInfo.add(method);
            }
            classInfo = classInfo.superClass();
        }
        return (MethodInfo[])allMethodInfo.toArray(MethodInfo[]::new);
    }

    static ConstructorInfo _findNoArgsConstructor(ClassInfo classInfo) {
        for (ConstructorInfo constructor : classInfo.constructors()) {
            if (constructor.parameters().length != 0) continue;
            return constructor;
        }
        return null;
    }

    static ConstructorInfo _findRecordConstructor(ClassInfo classInfo) {
        if (!classInfo.isRecord()) {
            return null;
        }
        JavaType[] recordComponentTypes = ReflectFactory._getRecordComponentsTypes(classInfo);
        for (ConstructorInfo constructor : classInfo.constructors()) {
            boolean matched = ReflectFactory._hasSameParameterTypes(constructor, recordComponentTypes);
            if (!matched) continue;
            return constructor;
        }
        return null;
    }

    static ClassInfo _findEnumClass(ClassInfo classInfo) {
        if (classInfo.isEnum()) {
            return classInfo.isAnonymousClass() ? classInfo.superClass() : classInfo;
        }
        return null;
    }

    private static JavaType[] _getRecordComponentsTypes(ClassInfo classInfo) {
        RecordComponent[] recordComponents = classInfo.type().getRawClass().getRecordComponents();
        JavaType[] result = new JavaType[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            result[i] = ReflectFactory._findType(recordComponents[i].getGenericType(), classInfo);
        }
        return result;
    }

    private static boolean _hasSameParameterTypes(ConstructorInfo constructorInfo, JavaType[] types) {
        if (constructorInfo.parameters().length != types.length) {
            return false;
        }
        ParameterInfo[] p1 = constructorInfo.parameters();
        for (int i = 0; i < p1.length; ++i) {
            Class p2Type;
            Class p1Type = p1[i].type().getRawClass();
            if (p1Type == (p2Type = types[i].getRawClass())) continue;
            return false;
        }
        return true;
    }

    static AccessModifier _findAccessModifier(ConstructorInfo constructorInfo) {
        return ReflectFactory._findAccessModifier(constructorInfo.constructor().getModifiers());
    }

    static ParameterInfo[] _findParameterInfos(ConstructorInfo constructorInfo) {
        Parameter[] parameters = constructorInfo.constructor().getParameters();
        ParameterInfo[] result = new ParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = new ParameterInfo(parameters[i], constructorInfo);
        }
        return result;
    }

    static String _findName(ParameterInfo parameterInfo) {
        return parameterInfo.parameter().getName();
    }

    static JavaType _findType(ParameterInfo parameterInfo) {
        return ReflectFactory._findType(parameterInfo.parameter().getParameterizedType(), parameterInfo.executableInfo().classInfo());
    }

    static String _findName(FieldInfo fieldInfo) {
        return fieldInfo.field().getName();
    }

    static AccessModifier _findAccessModifier(FieldInfo fieldInfo) {
        return ReflectFactory._findAccessModifier(fieldInfo.field().getModifiers());
    }

    static JavaType _findType(FieldInfo fieldInfo) {
        return ReflectFactory._findType(fieldInfo.field().getGenericType(), fieldInfo.classInfo());
    }

    static Annotation[] _findAnnotations(FieldInfo fieldInfo) {
        return fieldInfo.field().getDeclaredAnnotations();
    }

    static String _findName(MethodInfo methodInfo) {
        return methodInfo.method().getName();
    }

    static boolean _isAbstract(MethodInfo methodInfo) {
        return Modifier.isAbstract(methodInfo.method().getModifiers());
    }

    static AccessModifier _findAccessModifier(MethodInfo methodInfo) {
        return ReflectFactory._findAccessModifier(methodInfo.method().getModifiers());
    }

    static Annotation[] _findAnnotations(MethodInfo methodInfo) {
        return methodInfo.method().getDeclaredAnnotations();
    }

    static JavaType _findReturnType(MethodInfo methodInfo) {
        return ReflectFactory._findType(methodInfo.method().getGenericReturnType(), methodInfo.classInfo());
    }

    static ParameterInfo[] _findParameterInfos(MethodInfo methodInfo) {
        Parameter[] parameters = methodInfo.method().getParameters();
        ParameterInfo[] result = new ParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = new ParameterInfo(parameters[i], methodInfo);
        }
        return result;
    }

    static MethodInfo _findSuperMethod(MethodInfo methodInfo) {
        for (ClassInfo superClass = methodInfo.classInfo().superClass(); superClass != null; superClass = superClass.superClass()) {
            MethodInfo[] superMethods;
            for (MethodInfo superMethod : superMethods = superClass.methods()) {
                boolean b = ReflectFactory.isOverride(methodInfo, superMethod);
                if (!b) continue;
                return superMethod;
            }
        }
        return null;
    }

    static Annotation[] _findAllAnnotations(MethodInfo methodInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (methodInfo != null) {
            Collections.addAll(allAnnotations, methodInfo.annotations());
            methodInfo = methodInfo.superMethod();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }

    private static boolean isOverride(MethodInfo rootMethod, MethodInfo candidateMethod) {
        return AccessModifier.PRIVATE != candidateMethod.accessModifier() && candidateMethod.name().equals(rootMethod.name()) && ReflectFactory._hasSameParameterTypes(rootMethod, candidateMethod);
    }

    private static boolean _hasSameParameterTypes(MethodInfo rootMethod, MethodInfo candidateMethod) {
        if (candidateMethod.parameters().length != rootMethod.parameters().length) {
            return false;
        }
        ParameterInfo[] p1 = rootMethod.parameters();
        ParameterInfo[] p2 = candidateMethod.parameters();
        for (int i = 0; i < p1.length; ++i) {
            Class p2Type;
            Class p1Type = p1[i].type().getRawClass();
            if (p1Type == (p2Type = p2[i].type().getRawClass())) continue;
            return false;
        }
        return true;
    }
}

