/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.standard;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;

public enum JDBCType {
    TINYINT,
    SMALLINT,
    INT,
    BIGINT,
    FLOAT,
    DOUBLE,
    BOOLEAN,
    DECIMAL,
    DATE,
    TIME,
    DATETIME,
    VARCHAR,
    TEXT,
    LONGTEXT,
    BLOB,
    LONGBLOB,
    JSON;

    private static final Map<Class<?>, JDBCType> MAP;

    private static Map<Class<?>, JDBCType> initMap() {
        HashMap map = new HashMap();
        map.put(Byte.TYPE, TINYINT);
        map.put(Short.TYPE, SMALLINT);
        map.put(Integer.TYPE, INT);
        map.put(Long.TYPE, BIGINT);
        map.put(Float.TYPE, FLOAT);
        map.put(Double.TYPE, DOUBLE);
        map.put(Boolean.TYPE, BOOLEAN);
        map.put(Byte.class, TINYINT);
        map.put(Short.class, SMALLINT);
        map.put(Integer.class, INT);
        map.put(Long.class, BIGINT);
        map.put(Float.class, FLOAT);
        map.put(Double.class, DOUBLE);
        map.put(Boolean.class, BOOLEAN);
        map.put(BigInteger.class, BIGINT);
        map.put(BigDecimal.class, DECIMAL);
        map.put(LocalDate.class, DATE);
        map.put(LocalTime.class, TIME);
        map.put(LocalDateTime.class, DATETIME);
        map.put(OffsetTime.class, TIME);
        map.put(OffsetDateTime.class, DATETIME);
        map.put(ZonedDateTime.class, DATETIME);
        map.put(Duration.class, TIME);
        map.put(Instant.class, DATETIME);
        map.put(String.class, VARCHAR);
        map.put(byte[].class, BLOB);
        map.put(Byte[].class, BLOB);
        return map;
    }

    public static JDBCType getByJavaType(Class<?> javaType) {
        return MAP.get(javaType);
    }

    static {
        MAP = JDBCType.initMap();
    }
}

