/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.common.util.StringUtils;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CaseUtils {
    public static String toCamel(String str) {
        return CaseUtils.toCamel(str, CaseUtils.deduceCaseType(str));
    }

    public static String toPascal(String str) {
        return CaseUtils.toPascal(str, CaseUtils.deduceCaseType(str));
    }

    public static String toKebab(String str) {
        return CaseUtils.toKebab(str, CaseUtils.deduceCaseType(str));
    }

    public static String toSnake(String str) {
        return CaseUtils.toSnake(str, CaseUtils.deduceCaseType(str));
    }

    public static String toCamel(String str, CaseType caseType) {
        return CaseUtils.convert(str, CaseType.CAMEL_CASE, caseType);
    }

    public static String toPascal(String str, CaseType caseType) {
        return CaseUtils.convert(str, CaseType.PASCAL_CASE, caseType);
    }

    public static String toKebab(String str, CaseType caseType) {
        return CaseUtils.convert(str, CaseType.KEBAB_CASE, caseType);
    }

    public static String toSnake(String str, CaseType caseType) {
        return CaseUtils.convert(str, CaseType.SNAKE_CASE, caseType);
    }

    public static String convert(String str, CaseType to, CaseType from) {
        return from == to ? str : to.getString(from.getSourceStrings(str));
    }

    private static CaseType deduceCaseType(String str) {
        if (StringUtils.isBlank(str)) {
            return CaseType.BLANK;
        }
        if (str.contains("_")) {
            return CaseType.SNAKE_CASE;
        }
        if (str.contains("-")) {
            return CaseType.KEBAB_CASE;
        }
        return CaseType.PASCAL_CASE;
    }

    public static enum CaseType implements CaseTypeHandler
    {
        CAMEL_CASE(new CamelCaseHandler()),
        PASCAL_CASE(new PascalCaseHandler()),
        KEBAB_CASE(new KebabCaseHandler()),
        SNAKE_CASE(new SnakeCaseHandler()),
        BLANK(new BlankHandler());

        private final CaseTypeHandler handler;

        private CaseType(CaseTypeHandler handler) {
            this.handler = handler;
        }

        @Override
        public String[] getSourceStrings(String o) {
            return this.handler.getSourceStrings(o);
        }

        @Override
        public String getString(String[] s) {
            return this.handler.getString(s);
        }
    }

    private static final class KebabCaseHandler
    implements CaseTypeHandler {
        private KebabCaseHandler() {
        }

        @Override
        public String[] getSourceStrings(String s) {
            return s.split("-");
        }

        @Override
        public String getString(String[] s) {
            return Arrays.stream(s).map(String::toLowerCase).collect(Collectors.joining("-"));
        }
    }

    private static final class CamelCaseHandler
    extends PascalCaseHandler {
        private CamelCaseHandler() {
        }

        private static String makeFirstCharLowerCase(String string) {
            char[] charArray = string.toCharArray();
            if ('A' <= charArray[0] && charArray[0] <= 'Z') {
                charArray[0] = (char)(charArray[0] ^ 0x20);
            }
            return new String(charArray);
        }

        @Override
        public String getString(String[] s) {
            return CamelCaseHandler.makeFirstCharLowerCase(super.getString(s));
        }
    }

    private static final class BlankHandler
    implements CaseTypeHandler {
        private static final String[] EMPTY_ARRAY = new String[0];
        private static final String EMPTY_STRING = "";

        private BlankHandler() {
        }

        @Override
        public String[] getSourceStrings(String s) {
            return EMPTY_ARRAY;
        }

        @Override
        public String getString(String[] s) {
            return EMPTY_STRING;
        }
    }

    private static class PascalCaseHandler
    implements CaseTypeHandler {
        private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");

        private PascalCaseHandler() {
        }

        private static String makeFirstCharUpperCase(String string) {
            char[] charArray = string.toCharArray();
            if ('a' <= charArray[0] && charArray[0] <= 'z') {
                charArray[0] = (char)(charArray[0] ^ 0x20);
            }
            return new String(charArray);
        }

        @Override
        public String[] getSourceStrings(String s) {
            return SPLIT_PATTERN.split(s);
        }

        @Override
        public String getString(String[] ss) {
            return Arrays.stream(ss).map(s -> PascalCaseHandler.makeFirstCharUpperCase(s.toLowerCase())).collect(Collectors.joining());
        }
    }

    private static final class SnakeCaseHandler
    implements CaseTypeHandler {
        private SnakeCaseHandler() {
        }

        @Override
        public String[] getSourceStrings(String s) {
            return s.split("_");
        }

        @Override
        public String getString(String[] s) {
            return Arrays.stream(s).map(String::toLowerCase).collect(Collectors.joining("_"));
        }
    }

    private static interface CaseTypeHandler {
        public String[] getSourceStrings(String var1);

        public String getString(String[] var1);
    }
}

