/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.common.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public final class URIBuilder {
    private static final Pattern PATH_SEPARATOR = Pattern.compile("[/\\\\]+");

    public static String join(String ... uris) {
        return URIBuilder.normalize(String.join((CharSequence)"/", (CharSequence[])Arrays.stream(uris).filter(StringUtils::notBlank).toArray(String[]::new)));
    }

    public static String join(Collection<String> uris) {
        return URIBuilder.normalize(String.join((CharSequence)"/", (CharSequence[])uris.stream().filter(StringUtils::notBlank).toArray(String[]::new)));
    }

    public static String trimSlash(String uri) {
        char[] value = uri.toCharArray();
        int length = value.length;
        int st = URIBuilder.findSlashStart(value);
        int len = URIBuilder.findSlashEnd(value);
        return st > 0 || len < length ? new String(Arrays.copyOfRange(value, st, len)) : uri;
    }

    public static String trimSlashStart(String uri) {
        char[] value = uri.toCharArray();
        int st = URIBuilder.findSlashStart(value);
        return st > 0 ? new String(Arrays.copyOfRange(value, st, value.length)) : uri;
    }

    public static String trimSlashEnd(String uri) {
        char[] value = uri.toCharArray();
        int len = URIBuilder.findSlashEnd(value);
        return len < value.length ? new String(Arrays.copyOfRange(value, 0, len)) : uri;
    }

    private static int findSlashStart(char[] value) {
        int st;
        int length = value.length;
        for (st = 0; st < length && (value[st] == '/' || value[st] == '\\'); ++st) {
        }
        return st;
    }

    private static int findSlashEnd(char[] value) {
        int len;
        int st = 0;
        for (len = value.length; st < len && (value[len - 1] == '/' || value[len - 1] == '\\'); --len) {
        }
        return len;
    }

    public static String addSlashStart(String uri) {
        return "/" + URIBuilder.trimSlashStart(uri);
    }

    public static String addSlashEnd(String uri) {
        return URIBuilder.trimSlashEnd(uri) + "/";
    }

    public static String normalize(String uri) {
        char[] chars = uri.toCharArray();
        int index = 0;
        boolean isSeparator = false;
        for (char c : chars) {
            if (c == '/' || c == '\\') {
                if (!isSeparator) {
                    chars[index] = 47;
                    ++index;
                }
                isSeparator = true;
                continue;
            }
            chars[index] = c;
            ++index;
            isSeparator = false;
        }
        return new String(chars, 0, index);
    }

    public static String[] split(String uri) {
        return PATH_SEPARATOR.split(uri, -1);
    }
}

