/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.zip;

import cool.scx.common.io_stream_source.InputStreamSource;
import cool.scx.common.util.FileUtils;
import cool.scx.common.util.URIBuilder;
import cool.scx.common.zip.ZipOptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class UnZipBuilder {
    private final InputStreamSource source;
    private Path path = null;

    public UnZipBuilder(InputStreamSource source) {
        this.source = source;
    }

    public UnZipBuilder(Path path) {
        this(InputStreamSource.of(path));
        this.path = path;
    }

    public UnZipBuilder(byte[] bytes) {
        this(InputStreamSource.of(bytes));
    }

    public UnZipBuilder(Supplier<byte[]> bytesSupplier) {
        this(InputStreamSource.of(bytesSupplier));
    }

    public UnZipBuilder(InputStream inputStream) {
        this(InputStreamSource.of(inputStream));
    }

    public void toFile(Path outputPath, ZipOptions zipOptions) throws IOException {
        Files.createDirectories(outputPath, new FileAttribute[0]);
        String rootPath = this.getRootPath(zipOptions);
        try (ZipInputStream zis = new ZipInputStream(this.source.toInputStream(), zipOptions.charset());){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                Path unzipFilePath = outputPath.resolve(rootPath + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(unzipFilePath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(unzipFilePath.getParent(), new FileAttribute[0]);
                    Files.copy(zis, unzipFilePath, StandardCopyOption.REPLACE_EXISTING);
                }
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
    }

    public void toFile(Path outputPath) throws IOException {
        this.toFile(outputPath, new ZipOptions());
    }

    private String getRootPath(ZipOptions zipOptions) {
        if (zipOptions.includeRoot() && this.path != null) {
            String fileName = this.path.getFileName().toString();
            String fileNameWithoutExtension = FileUtils.getFileNameWithoutExtension(fileName);
            return URIBuilder.addSlashEnd(fileNameWithoutExtension);
        }
        return "";
    }
}

