/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.common.util.ScxExceptionHelper;
import cool.scx.common.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.jar.JarEntry;
import java.util.stream.Stream;

public final class ClassUtils {
    private static final ClassLoader DEFAULT_CLASS_LOADER = ClassUtils.class.getClassLoader();

    public static boolean isEnum(Class<?> c) {
        return Enum.class.isAssignableFrom(c);
    }

    public static Class<?> getEnumClass(Class<?> c) {
        if (ClassUtils.isEnum(c)) {
            return c.isAnonymousClass() ? c.getSuperclass() : c;
        }
        throw new IllegalArgumentException(c.getName() + ": Not an enum !!!");
    }

    public static boolean isInstantiableClass(Class<?> c) {
        return ClassUtils.isNormalClass(c) && ScxExceptionHelper.noException(() -> c.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    public static boolean isNormalClass(Class<?> c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }

    public static URI getCodeSource(Class<?> source) {
        return URI.create(source.getProtectionDomain().getCodeSource().getLocation().toString());
    }

    public static Path getAppRoot(URI codeSource) {
        Path path = Path.of(codeSource);
        return Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
    }

    public static Path getAppRoot(Class<?> source) {
        return ClassUtils.getAppRoot(ClassUtils.getCodeSource(source));
    }

    public static boolean isJar(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && StringUtils.endsWithIgnoreCase(path.toString(), ".jar");
    }

    public static Class<?>[] filterByBasePackage(Class<?>[] classList, String basePackageName) {
        String p = basePackageName + ".";
        return (Class[])Arrays.stream(classList).filter(c -> c.getPackageName().equals(basePackageName) || c.getPackageName().startsWith(p)).toArray(Class[]::new);
    }

    private static Class<?> loadClassFromJar(JarEntry jarEntry, ClassLoader jarClassLoader) {
        int suffixLength = ".class".length();
        String className = jarEntry.getName().substring(0, jarEntry.getName().length() - suffixLength).replace('/', '.');
        return ClassUtils.loadClass0(className, jarClassLoader);
    }

    private static Class<?> loadClassFromPath(Path classRealPath, ClassLoader classLoader) {
        int suffixLength = ".class.".length();
        StringBuilder str = new StringBuilder();
        for (Path path : classRealPath) {
            str.append(path.toString()).append(".");
        }
        String className = str.substring(0, str.length() - suffixLength);
        return ClassUtils.loadClass0(className, classLoader);
    }

    private static Class<?> loadClass0(String className, ClassLoader secondClassLoader) {
        try {
            return DEFAULT_CLASS_LOADER.loadClass(className);
        }
        catch (ClassNotFoundException t1) {
            try {
                return secondClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException t2) {
                return null;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static Class<?>[] findClassListFromJar(URI jarFileURI) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Class<?>[] findClassListFromPath(Path classRootPath, ClassLoader classLoader) throws IOException {
        try (Stream<Path> pathStream = Files.walk(classRootPath, new FileVisitOption[0]);){
            Class[] classArray = (Class[])pathStream.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".class")).map(path -> ClassUtils.loadClassFromPath(classRootPath.relativize((Path)path), classLoader)).toArray(Class[]::new);
            return classArray;
        }
    }

    private static /* synthetic */ Class[] lambda$findClassListFromJar$5(int x$0) {
        return new Class[x$0];
    }

    private static /* synthetic */ Class lambda$findClassListFromJar$4(URLClassLoader jarClassLoader, JarEntry jarEntry) {
        return ClassUtils.loadClassFromJar(jarEntry, jarClassLoader);
    }

    private static /* synthetic */ boolean lambda$findClassListFromJar$3(JarEntry jarEntry) {
        return !jarEntry.isDirectory() && jarEntry.getName().endsWith(".class");
    }
}

