/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import cool.scx.common.functional.ScxRunnable;
import cool.scx.common.util.MultiMap;
import cool.scx.common.util.ScxExceptionHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class $ {
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Timeout setTimeout(Runnable task, long delay) {
        return new Timeout(Thread.ofVirtual().start(() -> {
            try {
                Thread.sleep(delay);
                task.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }));
    }

    public static Timeout setInterval(Runnable task, long delay) {
        return new Timeout(Thread.ofVirtual().start(() -> {
            try {
                while (true) {
                    Thread.sleep(delay);
                    Thread.ofVirtual().start(task);
                }
            }
            catch (InterruptedException ignored) {
                return;
            }
        }));
    }

    public static CompletableFuture<Void> async(ScxRunnable<?> runnable) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        Thread.ofVirtual().start(() -> {
            try {
                runnable.run();
                promise.complete(null);
            }
            catch (Throwable e) {
                promise.completeExceptionally(e);
            }
        });
        return promise;
    }

    public static <T> CompletableFuture<T> async(Callable<T> callable) {
        CompletableFuture promise = new CompletableFuture();
        Thread.ofVirtual().start(() -> {
            try {
                Object t = callable.call();
                promise.complete(t);
            }
            catch (Throwable e) {
                promise.completeExceptionally(e);
            }
        });
        return promise;
    }

    public static <T> T await(CompletableFuture<T> promise) throws Throwable {
        try {
            return promise.get();
        }
        catch (Exception e) {
            throw ScxExceptionHelper.getRootCause(e);
        }
    }

    public static <K, T> MultiMap<K, T> groupingBy(Iterable<T> list, Function<? super T, ? extends K> keyFn) {
        return $.groupingBy(list, keyFn, (? super T t) -> t);
    }

    public static <K, V, T> MultiMap<K, V> groupingBy(Iterable<T> list, Function<? super T, ? extends K> keyFn, Function<? super T, ? extends V> valueFn) {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        for (T t : list) {
            K key = keyFn.apply(t);
            V value = valueFn.apply(t);
            multiMap.put(key, value);
        }
        return multiMap;
    }

    public static <K, T> MultiMap<K, T> groupingBy(T[] list, Function<? super T, ? extends K> keyFn) {
        return $.groupingBy(list, keyFn, (? super T t) -> t);
    }

    public static <K, V, T> MultiMap<K, V> groupingBy(T[] list, Function<? super T, ? extends K> keyFn, Function<? super T, ? extends V> valueFn) {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        for (T t : list) {
            K key = keyFn.apply(t);
            V value = valueFn.apply(t);
            multiMap.put(key, value);
        }
        return multiMap;
    }

    public static class Timeout {
        private final Thread thread;

        public Timeout(Thread thread) {
            this.thread = thread;
        }

        public void cancel() {
            this.thread.interrupt();
        }
    }
}

