/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import cool.scx.common.jackson.FieldFilter;
import cool.scx.common.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DeepFieldFilter
extends SimpleBeanPropertyFilter {
    private final FieldFilter fieldFilter;

    public DeepFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilter = fieldFilter;
    }

    public static boolean match(String[] e1, String[] e2) {
        if (e1.length != e2.length) {
            return false;
        }
        for (int i = 0; i < e1.length; ++i) {
            boolean b = DeepFieldFilter.match(e1[i], e2[i]);
            if (b) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String e1, String e2) {
        return e1.equals(e2) || e1.equals("*");
    }

    private String[] getFullPath(PropertyWriter writer, JsonGenerator jsonGenerator) {
        String name = writer.getName();
        JsonStreamContext context = jsonGenerator.getOutputContext();
        JsonPointer jsonPointer = context.getParent().pathAsPointer(false);
        String string = jsonPointer.toString();
        List split = Arrays.stream(string.split("/")).filter(StringUtils::notBlank).collect(Collectors.toList());
        split.add(name);
        return (String[])split.toArray(String[]::new);
    }

    public boolean matchAny(String[] fullPath) {
        for (String fieldName : this.fieldFilter.getFieldNames()) {
            if (!DeepFieldFilter.match(fieldName.split("\\."), fullPath)) continue;
            return true;
        }
        return false;
    }

    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        boolean f;
        String[] fullPath = this.getFullPath(writer, jgen);
        boolean matched = this.matchAny(fullPath);
        boolean bl = f = this.fieldFilter.getFilterMode() == FieldFilter.FilterMode.INCLUDED == matched;
        if (f) {
            writer.serializeAsField(pojo, jgen, provider);
        } else {
            writer.serializeAsOmittedField(pojo, jgen, provider);
        }
    }
}

