/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import cool.scx.common.jackson.BuildOptions;
import cool.scx.common.jackson.DeepFieldFilter;
import cool.scx.common.jackson.FieldFilter;
import cool.scx.common.jackson.IgnoreJsonIgnore;
import cool.scx.common.jackson.MyJavaTimeModule;
import cool.scx.common.jackson.NullKeySerializer;
import cool.scx.common.jackson.PropertyFilterMixIn;

public final class JacksonHelper {
    public static <M extends ObjectMapper, B extends MapperBuilder<M, B>> M createObjectMapper(MapperBuilder<M, B> mapperBuilder, BuildOptions o) {
        mapperBuilder.addModule((Module)new JavaTimeModule()).addModule((Module)new MyJavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, o.failOnUnknownProperties()).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, o.failOnEmptyBeans()).addMixIn(Object.class, PropertyFilterMixIn.class).filterProvider((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
        if (o.visibilityConfig() != null) {
            o.visibilityConfig().forEach((arg_0, arg_1) -> mapperBuilder.visibility(arg_0, arg_1));
        }
        ObjectMapper objectMapper = mapperBuilder.build();
        if (o.ignoreJsonIgnore()) {
            objectMapper.setAnnotationIntrospector((AnnotationIntrospector)IgnoreJsonIgnore.IGNORE_JSON_IGNORE);
        }
        if (o.ignoreNullValue()) {
            objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        }
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)NullKeySerializer.NULL_KEY_SERIALIZER);
        return (M)objectMapper;
    }

    public static FilterProvider getFilterProvider(FieldFilter fieldFilter) {
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter(PropertyFilterMixIn.PROPERTY_FILTER_MIX_IN, (SimpleBeanPropertyFilter)new DeepFieldFilter(fieldFilter));
        return filterProvider;
    }
}

