/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.jackson;

import java.util.Set;

public class FieldFilter {
    private final FilterMode filterMode;
    private final String[] fieldNames;

    private FieldFilter(FilterMode filterMode, String ... fieldNames) {
        this.filterMode = filterMode;
        this.fieldNames = (String[])Set.of(fieldNames).toArray(String[]::new);
    }

    public static FieldFilter ofIncluded(String ... fieldNames) {
        return new FieldFilter(FilterMode.INCLUDED, fieldNames);
    }

    public static FieldFilter ofExcluded(String ... fieldNames) {
        return new FieldFilter(FilterMode.EXCLUDED, fieldNames);
    }

    FilterMode getFilterMode() {
        return this.filterMode;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    static enum FilterMode {
        INCLUDED,
        EXCLUDED;

    }
}

